/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.id;

import cn.orionsec.kit.lang.id.SnowFlakeIdWorker;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Systems;
import cn.orionsec.kit.lang.utils.random.Randoms;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class SnowFlakes {
    private static final SnowFlakeIdWorker ID_WORKER = new SnowFlakeIdWorker(SnowFlakes.getWorkId(), SnowFlakes.getDataCenterId());

    public static Long nextId() {
        return ID_WORKER.nextId();
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int[] code = Strings.getCodePoints(hostAddress);
            int sums = 0;
            for (int b : code) {
                sums += b;
            }
            return sums % 32;
        }
        catch (UnknownHostException e) {
            return Randoms.randomInt(0, 31);
        }
    }

    private static Long getDataCenterId() {
        int[] cps = Strings.getCodePoints(Systems.HOST_NAME);
        int sums = 0;
        for (int i : cps) {
            sums += i;
        }
        return sums % 32;
    }
}

