/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.support.timeout;

import cn.orionsec.kit.lang.support.timeout.TimeoutChecker;
import cn.orionsec.kit.lang.support.timeout.TimeoutEndpoint;
import cn.orionsec.kit.lang.utils.Threads;
import java.util.ArrayList;
import java.util.List;

public class TimeoutCheckerImpl<T extends TimeoutEndpoint>
implements TimeoutChecker<T> {
    private final List<T> tasks = new ArrayList<T>();
    private final long delay;
    private boolean run;

    public TimeoutCheckerImpl() {
        this(500L);
    }

    public TimeoutCheckerImpl(long delay) {
        this.delay = delay;
        this.run = true;
    }

    @Override
    public void addTask(T task) {
        this.tasks.add(task);
    }

    @Override
    public void run() {
        while (this.run) {
            this.tasks.removeIf(ch -> ch.isDone() || ch.checkTimeout());
            Threads.sleep(this.delay);
        }
    }

    @Override
    public void clear() {
        this.tasks.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    @Override
    public boolean isRun() {
        return this.run;
    }

    @Override
    public List<T> getTasks() {
        return this.tasks;
    }

    @Override
    public void close() {
        this.run = false;
    }
}

