/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Arrays1;

public class Booleans {
    private Booleans() {
    }

    public static Boolean negate(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isNotTrue(Boolean bool) {
        return !Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean isNotFalse(Boolean bool) {
        return !Boolean.FALSE.equals(bool);
    }

    public static boolean toBoolean(Boolean bool) {
        return bool != null && bool != false;
    }

    public static boolean toBoolean(int value) {
        return value != 0;
    }

    public static String toString(boolean bool, String trueString, String falseString) {
        return bool ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (array == null) {
            return false;
        }
        if (array.length == 0) {
            return false;
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        if (array == null) {
            return false;
        }
        if (array.length == 0) {
            return false;
        }
        boolean[] primitive = Arrays1.unWrap(array);
        return Booleans.and(primitive) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean or(boolean ... array) {
        if (array == null) {
            return false;
        }
        if (array.length == 0) {
            return false;
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        if (array == null) {
            return false;
        }
        if (array.length == 0) {
            return false;
        }
        boolean[] primitive = Arrays1.unWrap(array);
        return Booleans.or(primitive) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static int compare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        if (x) {
            return 1;
        }
        return -1;
    }
}

