/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.utils.Strings;
import java.util.regex.Pattern;

public class Xsses {
    private static final Pattern SCRIPT_PATTERN = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.XSS_SCRIPT_PATTERN);
    private static final Pattern STYLE_PATTERN = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.XSS_STYLE_PATTERN);
    private static final Pattern HTML_TAG_PATTERN = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.XSS_HTML_TAG_PATTERN);

    private Xsses() {
    }

    public static String clean(String s) {
        if (Strings.isBlank(s)) {
            return s;
        }
        if (SCRIPT_PATTERN != null) {
            s = SCRIPT_PATTERN.matcher(s).replaceAll("");
        }
        if (STYLE_PATTERN != null) {
            s = STYLE_PATTERN.matcher(s).replaceAll("");
        }
        if (HTML_TAG_PATTERN != null) {
            s = HTML_TAG_PATTERN.matcher(s).replaceAll("");
        }
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll(" ", "&nbsp;");
        s = s.replaceAll("'", "&apos;");
        s = s.replaceAll("\"", "&quot;");
        s = s.replaceAll("\n", "<br/>");
        s = s.replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
        return s;
    }

    public static String recode(String s) {
        if (Strings.isBlank(s)) {
            return s;
        }
        s = s.replaceAll("&amp;", "&");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&nbsp;", " ");
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("<br/>", "\n");
        s = s.replaceAll("&nbsp;&nbsp;&nbsp;&nbsp;", "\t");
        return s;
    }
}

