/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.code;

import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.code.CodeGenerator;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarCodes
extends CodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BarCodes.class);

    public BarCodes() {
        this.format = BarcodeFormat.CODE_128;
        this.width = 200;
        this.height = 30;
        this.imgTopMargin = 10;
        this.imgButtonMargin = 10;
        this.wordsTopMargin = -5;
    }

    @Override
    protected BufferedImage getBufferedImage(String content) {
        try {
            BitMatrix bitMatrix = WRITER.encode(content, this.format, this.width, this.height, this.getEncodeHint());
            return MatrixToImageWriter.toBufferedImage((BitMatrix)bitMatrix);
        }
        catch (WriterException e) {
            return null;
        }
    }

    protected BufferedImage setMargin(BufferedImage image) {
        int newHeight = this.imgTopMargin + this.height + this.imgButtonMargin;
        BufferedImage outImage = new BufferedImage(this.width, newHeight, 1);
        Graphics2D g2d = outImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, newHeight);
        g2d.setColor(Color.BLACK);
        g2d.drawImage(image, 0, this.imgTopMargin, image.getWidth(), image.getHeight(), null);
        g2d.dispose();
        outImage.flush();
        return outImage;
    }

    @Override
    public void encode(String content, String words, OutputStream out) {
        try {
            BufferedImage image = this.getBufferedImage(content);
            if (!Strings.isBlank(words)) {
                image = this.insertWords(image, words);
            } else if (this.wordsTopMargin != 0 || this.wordsButtonMargin != 0) {
                image = this.setMargin(image);
            }
            ImageIO.write((RenderedImage)image, this.suffix, out);
        }
        catch (Exception e) {
            LOGGER.error("BarCodes.encode error", (Throwable)e);
        }
    }
}

