/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto.enums;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import java.security.Signature;

public enum RSASignature {
    NONE("NONEwithRSA"),
    MD5("MD5withRSA"),
    SHA1("SHA1WithRSA"),
    SHA224("SHA224WithRSA"),
    SHA256("SHA256WithRSA"),
    SHA384("SHA384WithRSA"),
    SHA512("SHA512WithRSA");

    private final String model;

    private RSASignature(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public Signature getSignature() {
        try {
            return Signature.getInstance(this.model);
        }
        catch (Exception e) {
            throw Exceptions.runtime(e);
        }
    }

    public static Signature getSignature(String model) {
        RSASignature[] values;
        if (Strings.isBlank(model)) {
            return null;
        }
        for (RSASignature value : values = RSASignature.values()) {
            if (!value.getModel().equalsIgnoreCase(model.trim())) continue;
            return value.getSignature();
        }
        return null;
    }
}

