/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto.symmetric;

import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.crypto.Keys;
import cn.orionsec.kit.lang.utils.crypto.enums.CipherAlgorithm;
import cn.orionsec.kit.lang.utils.crypto.enums.PaddingMode;
import cn.orionsec.kit.lang.utils.crypto.enums.WorkingMode;
import cn.orionsec.kit.lang.utils.crypto.symmetric.EcbSymmetric;
import cn.orionsec.kit.lang.utils.crypto.symmetric.ParamSymmetric;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class SymmetricBuilder {
    protected CipherAlgorithm algorithm;
    protected WorkingMode workingMode = WorkingMode.ECB;
    protected PaddingMode paddingMode = PaddingMode.PKCS5_PADDING;
    protected SecretKey secretKey;
    protected AlgorithmParameterSpec paramSpec;
    private byte[] aad;

    public static SymmetricBuilder create() {
        return new SymmetricBuilder();
    }

    public static SymmetricBuilder aes() {
        return new SymmetricBuilder().algorithm(CipherAlgorithm.AES);
    }

    public static SymmetricBuilder des() {
        return new SymmetricBuilder().algorithm(CipherAlgorithm.DES);
    }

    public static SymmetricBuilder des3() {
        return new SymmetricBuilder().algorithm(CipherAlgorithm.DES3);
    }

    public static SymmetricBuilder sm4() {
        return new SymmetricBuilder().algorithm(CipherAlgorithm.SM4);
    }

    public SymmetricBuilder algorithm(CipherAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public SymmetricBuilder workingMode(WorkingMode workingMode) {
        this.workingMode = workingMode;
        return this;
    }

    public SymmetricBuilder paddingMode(PaddingMode paddingMode) {
        this.paddingMode = paddingMode;
        return this;
    }

    public SymmetricBuilder secretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public SymmetricBuilder secretKey(byte[] secretKey) {
        this.secretKey = Keys.getSecretKey(secretKey, this.algorithm);
        return this;
    }

    public SymmetricBuilder generatorSecretKey(byte[] secretKey) {
        this.secretKey = Keys.generatorKey(secretKey, this.algorithm);
        return this;
    }

    public SymmetricBuilder generatorSecretKey(String secretKey) {
        this.secretKey = Keys.generatorKey(secretKey, this.algorithm);
        return this;
    }

    public SymmetricBuilder generatorSecretKey(byte[] secretKey, int keySize) {
        this.secretKey = Keys.generatorKey(secretKey, keySize, this.algorithm);
        return this;
    }

    public SymmetricBuilder generatorSecretKey(String secretKey, int keySize) {
        this.secretKey = Keys.generatorKey(secretKey, keySize, this.algorithm);
        return this;
    }

    public SymmetricBuilder ivSpec(IvParameterSpec ivSpec) {
        this.paramSpec = ivSpec;
        return this;
    }

    public SymmetricBuilder ivSpec(String iv) {
        return this.ivSpec(Strings.bytes(iv), false);
    }

    public SymmetricBuilder ivSpec(byte[] iv) {
        return this.ivSpec(iv, false);
    }

    public SymmetricBuilder ivSpec(String iv, int specLen) {
        return this.ivSpec(Strings.bytes(iv), specLen);
    }

    public SymmetricBuilder ivSpec(byte[] iv, int specLen) {
        this.paramSpec = Keys.getIvSpec(iv, specLen);
        return this;
    }

    public SymmetricBuilder ivSpec(String iv, boolean fill) {
        return this.ivSpec(Strings.bytes(iv), fill);
    }

    public SymmetricBuilder ivSpec(byte[] iv, boolean fill) {
        this.paramSpec = fill ? Keys.getIvSpec(this.algorithm, iv) : Keys.getIvSpec(iv);
        return this;
    }

    public SymmetricBuilder gcmSpec(GCMParameterSpec gcmSpec) {
        this.paramSpec = gcmSpec;
        return this;
    }

    public SymmetricBuilder gcmSpec(String gcm) {
        return this.gcmSpec(Strings.bytes(gcm), false);
    }

    public SymmetricBuilder gcmSpec(byte[] gcm) {
        return this.gcmSpec(gcm, false);
    }

    public SymmetricBuilder gcmSpec(String gcm, int specLen) {
        return this.gcmSpec(Strings.bytes(gcm), specLen);
    }

    public SymmetricBuilder gcmSpec(byte[] gcm, int specLen) {
        this.paramSpec = Keys.getGcmSpec(gcm, specLen);
        return this;
    }

    public SymmetricBuilder gcmSpec(String gcm, boolean fill) {
        return this.gcmSpec(Strings.bytes(gcm), fill);
    }

    public SymmetricBuilder gcmSpec(byte[] gcm, boolean fill) {
        this.paramSpec = fill ? Keys.getGcmSpec(this.algorithm, gcm) : Keys.getGcmSpec(gcm);
        return this;
    }

    public SymmetricBuilder paramSpec(AlgorithmParameterSpec paramSpec) {
        this.paramSpec = paramSpec;
        return this;
    }

    public SymmetricBuilder aad(String aad) {
        return this.aad(Strings.bytes(aad));
    }

    public SymmetricBuilder aad(byte[] aad) {
        this.aad = aad;
        return this;
    }

    public EcbSymmetric buildEcb() {
        return new EcbSymmetric(this.algorithm, this.paddingMode, this.secretKey);
    }

    public ParamSymmetric buildParam() {
        ParamSymmetric symmetric = new ParamSymmetric(this.algorithm, this.workingMode, this.paddingMode, this.secretKey, this.paramSpec);
        symmetric.setAad(this.aad);
        return symmetric;
    }
}

