/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.identity;

import cn.orionsec.kit.lang.utils.random.Randoms;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CreditCodes {
    private static final int[] WEIGHT = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
    private static final char[] BASE_CODE_ARRAY = "0123456789ABCDEFGHJKLMNPQRTUWXY".toCharArray();
    private static final Map<Character, Integer> CODE_INDEX_MAP = new ConcurrentHashMap<Character, Integer>();

    private CreditCodes() {
    }

    public static boolean validCreditCode(String creditCode) {
        if (!Matches.isCreditCode(creditCode)) {
            return false;
        }
        int parityBit = CreditCodes.getParityBit(creditCode);
        if (parityBit < 0) {
            return false;
        }
        return creditCode.charAt(17) == BASE_CODE_ARRAY[parityBit];
    }

    public static String random() {
        int num;
        int i;
        StringBuilder buf = new StringBuilder(18);
        for (i = 0; i < 2; ++i) {
            num = Randoms.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(Character.toUpperCase(BASE_CODE_ARRAY[num]));
        }
        for (i = 2; i < 8; ++i) {
            num = Randoms.randomInt(10);
            buf.append(Character.toUpperCase(BASE_CODE_ARRAY[num]));
        }
        for (i = 8; i < 17; ++i) {
            num = Randoms.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(Character.toUpperCase(BASE_CODE_ARRAY[num]));
        }
        String code = buf.toString();
        return code + BASE_CODE_ARRAY[CreditCodes.getParityBit(code)];
    }

    public static int getParityBit(String creditCode) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            Integer codeIndex = CODE_INDEX_MAP.get(Character.valueOf(creditCode.charAt(i)));
            if (codeIndex == null) {
                return -1;
            }
            sum += codeIndex * WEIGHT[i];
        }
        int result = 31 - sum % 31;
        return result == 31 ? 0 : result;
    }

    static {
        for (int i = 0; i < BASE_CODE_ARRAY.length; ++i) {
            CODE_INDEX_MAP.put(Character.valueOf(BASE_CODE_ARRAY[i]), i);
        }
    }
}

