/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io;

import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class StreamReaders {
    private StreamReaders() {
    }

    public static int read(InputStream in, byte[] bytes) throws IOException {
        return StreamReaders.read(in, bytes, 0L);
    }

    public static int read(InputStream in, byte[] bytes, long skip) throws IOException {
        if (skip > 0L) {
            in.skip(skip);
        }
        return in.read(bytes);
    }

    public static byte[] readAllBytes(InputStream in) throws IOException {
        return Streams.toByteArray(in);
    }

    public static String readLine(Reader reader) throws IOException {
        return StreamReaders.readLine(reader, 0);
    }

    public static String readLine(Reader reader, long skip) throws IOException {
        BufferedReader bufferedReader = Streams.toBufferedReader(reader);
        if (skip > 0L) {
            reader.skip(skip);
        }
        return bufferedReader.readLine();
    }

    public static String readLine(Reader reader, int skipLine) throws IOException {
        BufferedReader bufferedReader = Streams.toBufferedReader(reader);
        if (skipLine > 0) {
            for (int i = 0; i < skipLine; ++i) {
                if (bufferedReader.readLine() != null) continue;
                return null;
            }
        }
        return bufferedReader.readLine();
    }

    public static List<String> readLines(InputStream input) throws IOException {
        return StreamReaders.readLines((Reader)new InputStreamReader(input), 0L, 0);
    }

    public static List<String> readLines(InputStream input, String charset) throws IOException {
        if (charset == null) {
            return StreamReaders.readLines((Reader)new InputStreamReader(input), 0L, 0);
        }
        return StreamReaders.readLines((Reader)new InputStreamReader(input, charset), 0L, 0);
    }

    public static List<String> readLines(InputStream input, int lines) throws IOException {
        return StreamReaders.readLines((Reader)new InputStreamReader(input), 0L, lines);
    }

    public static List<String> readLines(InputStream input, String charset, int lines) throws IOException {
        if (charset == null) {
            return StreamReaders.readLines((Reader)new InputStreamReader(input), 0L, lines);
        }
        return StreamReaders.readLines((Reader)new InputStreamReader(input, charset), 0L, lines);
    }

    public static List<String> readLines(InputStream input, long skip, int lines) throws IOException {
        return StreamReaders.readLines((Reader)new InputStreamReader(input), skip, lines);
    }

    public static List<String> readLines(InputStream input, int skipLine, int lines) throws IOException {
        return StreamReaders.readLines((Reader)new InputStreamReader(input), skipLine, lines);
    }

    public static List<String> readLines(InputStream input, String charset, long skip, int lines) throws IOException {
        if (charset == null) {
            return StreamReaders.readLines((Reader)new InputStreamReader(input), skip, lines);
        }
        return StreamReaders.readLines((Reader)new InputStreamReader(input, charset), skip, lines);
    }

    public static List<String> readLines(InputStream input, String charset, int skipLine, int lines) throws IOException {
        if (charset == null) {
            return StreamReaders.readLines((Reader)new InputStreamReader(input), skipLine, lines);
        }
        return StreamReaders.readLines((Reader)new InputStreamReader(input, charset), skipLine, lines);
    }

    public static List<String> readLines(Reader reader) throws IOException {
        return StreamReaders.readLines(reader, 0L, 0);
    }

    public static List<String> readLines(Reader reader, int lines) throws IOException {
        return StreamReaders.readLines(reader, 0L, lines);
    }

    public static List<String> readLines(Reader reader, long skip, int lines) throws IOException {
        return StreamReaders.readLines(reader, skip, 0, lines);
    }

    public static List<String> readLines(Reader reader, int skipLine, int lines) throws IOException {
        return StreamReaders.readLines(reader, 0L, skipLine, lines);
    }

    private static List<String> readLines(Reader reader, long skip, int skipLine, int lines) throws IOException {
        BufferedReader bufferedReader = Streams.toBufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        if (skip > 0L) {
            reader.skip(skip);
        }
        if (skipLine > 0) {
            for (int i = 0; i < skipLine; ++i) {
                if (bufferedReader.readLine() != null) continue;
                return list;
            }
        }
        if (lines <= 0) {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                list.add(line);
            }
        } else {
            String line;
            int i = 0;
            while ((line = bufferedReader.readLine()) != null && ++i <= lines) {
                list.add(line);
            }
        }
        return list;
    }
}

