/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.tar;

import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileDecompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class TarDecompressor
extends BaseFileDecompressor {
    private TarArchiveInputStream inputStream;

    public TarDecompressor() {
        this("tar");
    }

    public TarDecompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecompress() throws Exception {
        try {
            ArchiveEntry entry;
            this.inputStream = new TarArchiveInputStream(Files1.openInputStreamFast(this.decompressFile));
            while ((entry = this.inputStream.getNextEntry()) != null) {
                File file = new File(this.decompressTargetPath, entry.getName());
                if (entry.isDirectory()) {
                    Files1.mkdirs(file);
                    continue;
                }
                OutputStream out = Files1.openOutputStreamFast(file);
                Throwable throwable = null;
                try {
                    Streams.transfer((InputStream)this.inputStream, out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        finally {
            Streams.close((AutoCloseable)this.inputStream);
        }
    }

    public TarArchiveInputStream getCloseable() {
        return this.inputStream;
    }
}

