/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.crypto;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.crypto.AES;
import cn.orionsec.kit.lang.utils.crypto.Keys;
import cn.orionsec.kit.lang.utils.crypto.enums.CipherAlgorithm;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.concurrent.Callable;
import javax.crypto.SecretKey;

public class FileDecrypt
implements Callable<Boolean> {
    private final BufferedReader reader;
    private final OutputStream out;
    private final String password;
    private final boolean autoClose;

    public FileDecrypt(File file, File dest, String password) {
        this(file, dest, password, 8192);
    }

    public FileDecrypt(String file, String dest, String password) {
        this(file, dest, password, 8192);
    }

    public FileDecrypt(InputStream in, OutputStream out, String password) {
        this(in, out, password, 8192);
    }

    public FileDecrypt(Reader reader, OutputStream out, String password) {
        this(reader, out, password, 8192);
    }

    public FileDecrypt(String file, String dest, String password, int bufferSize) {
        this(new File(file), new File(dest), password, bufferSize);
    }

    public FileDecrypt(File file, File dest, String password, int bufferSize) {
        this.autoClose = true;
        this.password = password;
        try {
            Files1.touch(dest);
            this.reader = new BufferedReader(new FileReader(file), bufferSize);
            this.out = Files1.openOutputStream(dest);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public FileDecrypt(InputStream in, OutputStream out, String password, int bufferSize) {
        this.autoClose = false;
        this.password = password;
        this.reader = new BufferedReader(new InputStreamReader(in), bufferSize);
        this.out = out;
    }

    public FileDecrypt(Reader reader, OutputStream out, String password, int bufferSize) {
        this.autoClose = false;
        this.password = password;
        this.reader = new BufferedReader(reader, bufferSize);
        this.out = out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() {
        SecretKey secretKey = Keys.generatorKey(this.password, CipherAlgorithm.AES);
        try {
            String line;
            while ((line = this.reader.readLine()) != null) {
                byte[] d = AES.decrypt(Strings.bytes(line), secretKey);
                this.out.write(d);
            }
            this.out.flush();
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Boolean bl = false;
            return bl;
        }
        finally {
            if (this.autoClose) {
                Streams.close(this.reader);
                Streams.close(this.out);
            }
        }
    }
}

