/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.math;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Compares;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import java.text.DecimalFormat;

public class Numbers {
    private Numbers() {
    }

    public static int getRangeNum(int num, int startRange, int endRange) {
        Valid.gte(startRange, 0, "start range must greater than or equal 0", new Object[0]);
        Valid.gt(endRange, startRange, "end range must greater than start range", new Object[0]);
        return startRange + num % (endRange - startRange);
    }

    public static boolean isZero(byte x) {
        return x == 0;
    }

    public static boolean isZero(short x) {
        return x == 0;
    }

    public static boolean isZero(int x) {
        return x == 0;
    }

    public static boolean isZero(long x) {
        return x == 0L;
    }

    public static boolean isZero(float x) {
        return x == 0.0f;
    }

    public static boolean isZero(double x) {
        return x == 0.0;
    }

    public static boolean isNotZero(byte x) {
        return x != 0;
    }

    public static boolean isNotZero(short x) {
        return x != 0;
    }

    public static boolean isNotZero(int x) {
        return x != 0;
    }

    public static boolean isNotZero(long x) {
        return x != 0L;
    }

    public static boolean isNotZero(float x) {
        return x != 0.0f;
    }

    public static boolean isNotZero(double x) {
        return x != 0.0;
    }

    public static boolean ltZero(byte x) {
        return x < 0;
    }

    public static boolean ltZero(short x) {
        return x < 0;
    }

    public static boolean ltZero(int x) {
        return x < 0;
    }

    public static boolean ltZero(long x) {
        return x < 0L;
    }

    public static boolean ltZero(float x) {
        return x < 0.0f;
    }

    public static boolean ltZero(double x) {
        return x < 0.0;
    }

    public static boolean lteZero(byte x) {
        return x <= 0;
    }

    public static boolean lteZero(short x) {
        return x <= 0;
    }

    public static boolean lteZero(int x) {
        return x <= 0;
    }

    public static boolean lteZero(long x) {
        return x <= 0L;
    }

    public static boolean lteZero(float x) {
        return x <= 0.0f;
    }

    public static boolean lteZero(double x) {
        return x <= 0.0;
    }

    public static boolean gtZero(byte x) {
        return x > 0;
    }

    public static boolean gtZero(short x) {
        return x > 0;
    }

    public static boolean gtZero(int x) {
        return x > 0;
    }

    public static boolean gtZero(long x) {
        return x > 0L;
    }

    public static boolean gtZero(float x) {
        return x > 0.0f;
    }

    public static boolean gtZero(double x) {
        return x > 0.0;
    }

    public static boolean gteZero(byte x) {
        return x >= 0;
    }

    public static boolean gteZero(short x) {
        return x >= 0;
    }

    public static boolean gteZero(int x) {
        return x >= 0;
    }

    public static boolean gteZero(long x) {
        return x >= 0L;
    }

    public static boolean gteZero(float x) {
        return x >= 0.0f;
    }

    public static boolean gteZero(double x) {
        return x >= 0.0;
    }

    public static boolean isAllZero(byte ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(short ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (short b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(int ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (int b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(long ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (long b : array) {
            if (b == 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (float b : array) {
            if (b == 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllZero(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (double b : array) {
            if (b == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(byte ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (byte b : array) {
            if (b != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(short ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (short b : array) {
            if (b != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(int ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (int b : array) {
            if (b != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(long ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (long b : array) {
            if (b != 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (float b : array) {
            if (b != 0.0f) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneZero(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (double b : array) {
            if (b != 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNegative(byte x) {
        return x < 0;
    }

    public static boolean isNegative(short x) {
        return x < 0;
    }

    public static boolean isNegative(int x) {
        return x < 0;
    }

    public static boolean isNegative(long x) {
        return x < 0L;
    }

    public static boolean isNegative(float x) {
        return x < 0.0f;
    }

    public static boolean isNegative(double x) {
        return x < 0.0;
    }

    public static boolean isNotNegative(byte x) {
        return x >= 0;
    }

    public static boolean isNotNegative(short x) {
        return x >= 0;
    }

    public static boolean isNotNegative(int x) {
        return x >= 0;
    }

    public static boolean isNotNegative(long x) {
        return x >= 0L;
    }

    public static boolean isNotNegative(float x) {
        return x >= 0.0f;
    }

    public static boolean isNotNegative(double x) {
        return x >= 0.0;
    }

    public static boolean isAllNegative(byte ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (byte b : array) {
            if (b < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNegative(short ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (short b : array) {
            if (b < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNegative(int ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (int b : array) {
            if (b < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNegative(long ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (long b : array) {
            if (b < 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNegative(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (float b : array) {
            if (!(b >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNegative(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (double b : array) {
            if (!(b >= 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(byte ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (byte b : array) {
            if (b >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(short ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (short b : array) {
            if (b >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(int ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (int b : array) {
            if (b >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(long ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (long b : array) {
            if (b >= 0L) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (float b : array) {
            if (!(b < 0.0f)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNegative(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (double b : array) {
            if (!(b < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNaN(Float x) {
        return x.isNaN();
    }

    public static boolean isNaN(Double x) {
        return x.isNaN();
    }

    public static boolean isNotNaN(Float x) {
        return !x.isNaN();
    }

    public static boolean isNotNaN(Double x) {
        return !x.isNaN();
    }

    public static boolean isAllNaN(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (float b : array) {
            if (Float.isNaN(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNaN(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return false;
        }
        for (double b : array) {
            if (Double.isNaN(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNaN(float ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (float b : array) {
            if (!Float.isNaN(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNaN(double ... array) {
        if (Arrays1.isEmpty(array)) {
            return true;
        }
        for (double b : array) {
            if (!Double.isNaN(b)) continue;
            return false;
        }
        return true;
    }

    public static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(float x, float y) {
        return Float.compare(x, y);
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static byte min(byte ... array) {
        byte min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static short min(short ... array) {
        short min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static int min(int ... array) {
        int min = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] >= min) continue;
            min = array[j];
        }
        return min;
    }

    public static long min(long ... array) {
        long min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    public static float min(float ... array) {
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Float.isNaN(array[i])) {
                return Float.NaN;
            }
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static double min(double ... array) {
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (Double.isNaN(array[i])) {
                return Double.NaN;
            }
            if (!(array[i] < min)) continue;
            min = array[i];
        }
        return min;
    }

    public static byte max(byte ... array) {
        byte max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static short max(short ... array) {
        short max = array[0];
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    public static int max(int ... array) {
        int max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max) continue;
            max = array[j];
        }
        return max;
    }

    public static long max(long ... array) {
        long max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max) continue;
            max = array[j];
        }
        return max;
    }

    public static float max(float ... array) {
        float max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Float.isNaN(array[j])) {
                return Float.NaN;
            }
            if (!(array[j] > max)) continue;
            max = array[j];
        }
        return max;
    }

    public static double max(double ... array) {
        double max = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Double.isNaN(array[j])) {
                return Double.NaN;
            }
            if (!(array[j] > max)) continue;
            max = array[j];
        }
        return max;
    }

    public static long sum(byte ... array) {
        long max = 0L;
        for (int j = 0; j < array.length; ++j) {
            max += (long)array[j];
        }
        return max;
    }

    public static long sum(short ... array) {
        long max = 0L;
        for (int j = 0; j < array.length; ++j) {
            max += (long)array[j];
        }
        return max;
    }

    public static long sum(int ... array) {
        long max = 0L;
        for (int j = 0; j < array.length; ++j) {
            max += (long)array[j];
        }
        return max;
    }

    public static long sum(long ... array) {
        long max = 0L;
        for (int j = 0; j < array.length; ++j) {
            max += array[j];
        }
        return max;
    }

    public static double sum(float ... array) {
        double max = 0.0;
        for (int j = 0; j < array.length; ++j) {
            if (Float.isNaN(array[j])) continue;
            max += (double)array[j];
        }
        return max;
    }

    public static double sum(double ... array) {
        double max = 0.0;
        for (int j = 0; j < array.length; ++j) {
            if (Double.isNaN(array[j])) continue;
            max += array[j];
        }
        return max;
    }

    public static byte avg(byte ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0;
        }
        return (byte)(Numbers.sum(array) / (long)len);
    }

    public static short avg(short ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0;
        }
        return (short)(Numbers.sum(array) / (long)len);
    }

    public static int avg(int ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0;
        }
        return (int)(Numbers.sum(array) / (long)len);
    }

    public static long avg(long ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0L;
        }
        return Numbers.sum(array) / (long)len;
    }

    public static float avg(float ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0.0f;
        }
        return (float)(Numbers.sum(array) / (double)len);
    }

    public static double avg(double ... array) {
        int len = Arrays1.length(array);
        if (len == 0) {
            return 0.0;
        }
        return Numbers.sum(array) / (double)len;
    }

    public static boolean inRange(byte num, byte start, byte end) {
        return Compares.inRange(num, start, end);
    }

    public static boolean inRange(short num, short start, short end) {
        return Compares.inRange(num, start, end);
    }

    public static boolean inRange(int num, int start, int end) {
        return Compares.inRange(num, start, end);
    }

    public static boolean inRange(long num, long start, long end) {
        return Compares.inRange(num, start, end);
    }

    public static boolean inRange(float num, float start, float end) {
        return Compares.inRange(Float.valueOf(num), Float.valueOf(start), Float.valueOf(end));
    }

    public static boolean inRange(double num, double start, double end) {
        return Compares.inRange(num, start, end);
    }

    public static boolean notInRange(byte num, byte start, byte end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean notInRange(short num, short start, short end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean notInRange(int num, int start, int end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean notInRange(long num, long start, long end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean notInRange(float num, float start, float end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean notInRange(double num, double start, double end) {
        return !Numbers.inRange(num, start, end);
    }

    public static boolean rangeInRange(byte rangeStart, byte rangeEnd, byte testRangeStart, byte testRangeEnd) {
        return Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeInRange(short rangeStart, short rangeEnd, short testRangeStart, short testRangeEnd) {
        return Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeInRange(int rangeStart, int rangeEnd, int testRangeStart, int testRangeEnd) {
        return Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeInRange(long rangeStart, long rangeEnd, long testRangeStart, long testRangeEnd) {
        return Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeInRange(float rangeStart, float rangeEnd, float testRangeStart, float testRangeEnd) {
        return Compares.rangeInRange(Float.valueOf(rangeStart), Float.valueOf(rangeEnd), Float.valueOf(testRangeStart), Float.valueOf(testRangeEnd));
    }

    public static boolean rangeInRange(double rangeStart, double rangeEnd, double testRangeStart, double testRangeEnd) {
        return Compares.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(byte rangeStart, byte rangeEnd, byte testRangeStart, byte testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(short rangeStart, short rangeEnd, short testRangeStart, short testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(int rangeStart, int rangeEnd, int testRangeStart, int testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(long rangeStart, long rangeEnd, long testRangeStart, long testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(float rangeStart, float rangeEnd, float testRangeStart, float testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean rangeNotInRange(double rangeStart, double rangeEnd, double testRangeStart, double testRangeEnd) {
        return !Numbers.rangeInRange(rangeStart, rangeEnd, testRangeStart, testRangeEnd);
    }

    public static boolean cross(byte start1, byte end1, byte start2, byte end2) {
        return Compares.cross(start1, end1, start2, end2);
    }

    public static boolean cross(short start1, short end1, short start2, short end2) {
        return Compares.cross(start1, end1, start2, end2);
    }

    public static boolean cross(int start1, int end1, int start2, int end2) {
        return Compares.cross(start1, end1, start2, end2);
    }

    public static boolean cross(long start1, long end1, long start2, long end2) {
        return Compares.cross(start1, end1, start2, end2);
    }

    public static boolean cross(float start1, float end1, float start2, float end2) {
        return Compares.cross(Float.valueOf(start1), Float.valueOf(end1), Float.valueOf(start2), Float.valueOf(end2));
    }

    public static boolean cross(double start1, double end1, double start2, double end2) {
        return Compares.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(byte start1, byte end1, byte start2, byte end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(short start1, short end1, short start2, short end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(int start1, int end1, int start2, int end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(long start1, long end1, long start2, long end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(float start1, float end1, float start2, float end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static boolean uncross(double start1, double end1, double start2, double end2) {
        return !Numbers.cross(start1, end1, start2, end2);
    }

    public static String format(float value, String format) {
        return new DecimalFormat(format).format(value);
    }

    public static String format(double value, String format) {
        return new DecimalFormat(format).format(value);
    }

    public static int cleanDecimal(float f) {
        return Integer.parseInt(new DecimalFormat("#").format(f));
    }

    public static long cleanDecimal(double d) {
        return Long.parseLong(new DecimalFormat("#").format(d));
    }

    public static String cleanFloatDecimal(float f) {
        return new DecimalFormat("#").format(f);
    }

    public static String cleanDoubleDecimal(double d) {
        return new DecimalFormat("#").format(d);
    }

    public static String setScale(double d, int decimalLen) {
        DecimalFormat format = new DecimalFormat("0." + Strings.repeat('0', decimalLen));
        return format.format(d);
    }

    public static String setScale(float f, int decimalLen) {
        DecimalFormat format = new DecimalFormat("0." + Strings.repeat('0', decimalLen));
        return format.format(f);
    }

    public static boolean isDecimal(float f) {
        return Float.compare(f, (int)f) != 0;
    }

    public static boolean isDecimal(double d) {
        return Double.compare(d, (long)d) != 0;
    }

    public static int getMin2Power(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        return n + 1;
    }
}

