/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.reflect.Types;
import cn.orionsec.kit.lang.utils.reflect.type.TypeReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class Generics {
    private Generics() {
    }

    public static Class<?> getFieldGenericType(Field field, int genericIndex) {
        Class<?>[] types = Types.getTypeParameterizedTypes(field.getGenericType());
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getFieldGenericTypes(Field field) {
        return Types.getTypeParameterizedTypes(field.getGenericType());
    }

    public static Class<?> getMethodParameterGenericType(Method method, int parameterIndex, int genericIndex) {
        Class<?>[] types = Types.getTypeParameterizedTypes(method.getGenericParameterTypes()[parameterIndex]);
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getMethodParameterGenericTypes(Method method, int parameterIndex) {
        return Types.getTypeParameterizedTypes(method.getGenericParameterTypes()[parameterIndex]);
    }

    public static Class<?>[][] getMethodParameterGenericTypes(Method method) {
        return (Class[][])Arrays.stream(method.getGenericParameterTypes()).map(Types::getTypeParameterizedTypes).toArray(x$0 -> new Class[x$0][]);
    }

    public static Class<?> getMethodReturnGenericType(Method method, int genericIndex) {
        Class<?>[] types = Types.getTypeParameterizedTypes(method.getGenericReturnType());
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getMethodReturnGenericTypes(Method method) {
        return Types.getTypeParameterizedTypes(method.getGenericReturnType());
    }

    public static Class<?> getClassGenericType(TypeReference<?> ref, int genericIndex) {
        Class<?>[] types = Types.getTypeParameterizedTypes(ref.getType());
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getClassGenericTypes(TypeReference<?> ref) {
        return Types.getTypeParameterizedTypes(ref.getType());
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, int genericIndex) {
        Class<?>[] types = Types.getTypeParameterizedTypes(clazz.getGenericSuperclass());
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getSuperClassGenericTypes(Class<?> clazz) {
        return Types.getTypeParameterizedTypes(clazz.getGenericSuperclass());
    }

    public static Class<?> getInterfaceGenericType(Class<?> clazz, Class<?> interfaceClass, int genericIndex) {
        Class<?>[] types = Generics.getInterfaceGenericTypes(clazz, interfaceClass);
        if (types == null) {
            return null;
        }
        return Valid.validIndex(types, genericIndex);
    }

    public static Class<?>[] getInterfaceGenericTypes(Class<?> clazz, Class<?> interfaceClass) {
        for (Type type : clazz.getGenericInterfaces()) {
            if (interfaceClass.equals(type)) break;
            if (!(type instanceof ParameterizedType) || !interfaceClass.equals(((ParameterizedType)type).getRawType())) continue;
            return Types.getTypeParameterizedTypes(type);
        }
        return null;
    }

    public static Map<Class<?>, Class<?>[]> getInterfaceGenericTypes(Class<?> clazz) {
        LinkedHashMap map = new LinkedHashMap();
        for (Type type : clazz.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            Type rawClass = ((ParameterizedType)type).getRawType();
            map.put((Class)rawClass, Types.getTypeParameterizedTypes(type));
        }
        return map;
    }
}

