/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.time.ago;

import cn.orionsec.kit.lang.utils.time.Dates;
import cn.orionsec.kit.lang.utils.time.ago.Ago;
import cn.orionsec.kit.lang.utils.time.ago.DateAgoHint;
import java.util.Calendar;
import java.util.Date;

public class DateAgo
extends Ago {
    private boolean vague = true;
    private boolean useWeek;

    public DateAgo(Date target) {
        super(target);
    }

    public DateAgo(Date source, Date target) {
        super(source, target);
    }

    public DateAgo(Date target, DateAgoHint hint) {
        super(target, hint);
    }

    public DateAgo(Date source, Date target, DateAgoHint hint) {
        super(source, target, hint);
    }

    public static DateAgo of(Date target) {
        return new DateAgo(target);
    }

    public static DateAgo of(Date source, Date target) {
        return new DateAgo(source, target);
    }

    public DateAgo vague(boolean vague) {
        this.vague = vague;
        return this;
    }

    public DateAgo useWeek(boolean useWeek) {
        this.useWeek = useWeek;
        return this;
    }

    @Override
    public String ago() {
        if (this.hint == null) {
            this.hint = new DateAgoHint();
        }
        Calendar c1 = Dates.calendar(this.source);
        Calendar c2 = Dates.calendar(this.target);
        long s = this.source.getTime();
        long t = this.target.getTime();
        int sYear = c1.get(1);
        int tYear = c2.get(1);
        int sDay = c1.get(5);
        int tDay = c2.get(5);
        if (s - t > 0L) {
            long before = s - t;
            if (sYear - tYear > 10 && this.vague) {
                return this.hint.longAgo;
            }
            if (sYear - tYear == 1 && this.vague) {
                return this.hint.lastYear;
            }
            if (before > 31536000000L) {
                return before / 31536000000L + this.hint.yearAgo;
            }
            if (before > 2592000000L) {
                return before / 2592000000L != 12L ? before / 2592000000L + this.hint.monthAgo : 1 + this.hint.yearAgo;
            }
            if (before > 604800000L && this.useWeek) {
                return before / 604800000L + this.hint.weekAgo;
            }
            if (sDay - tDay == 1 && this.vague) {
                return this.hint.yesterday;
            }
            if (sDay - tDay == 2 && this.vague) {
                return this.hint.beforeYesterday;
            }
            if (before > 86400000L) {
                return before / 86400000L + this.hint.dayAgo;
            }
            if (before > 3600000L) {
                return before / 3600000L + this.hint.hourAgo;
            }
            if (before > 60000L) {
                return before / 60000L + this.hint.minuteAgo;
            }
            return this.vague ? this.hint.justNow : before / 1000L + this.hint.secondAgo;
        }
        if (t - s > 0L) {
            long after = t - s;
            if (tYear - sYear > 10 && this.vague) {
                return this.hint.longFuture;
            }
            if (tYear - sYear == 1 && this.vague) {
                return this.hint.nextYear;
            }
            if (after > 31536000000L) {
                return after / 31536000000L + this.hint.yearFuture;
            }
            if (after > 2592000000L) {
                return after / 2592000000L != 12L ? after / 2592000000L + this.hint.monthFuture : 1 + this.hint.yearFuture;
            }
            if (after > 604800000L && this.useWeek) {
                return after / 604800000L + this.hint.weekAgo;
            }
            if (tDay - sDay == 1 && this.vague) {
                return this.hint.tomorrow;
            }
            if (tDay - sDay == 2 && this.vague) {
                return this.hint.afterTomorrow;
            }
            if (after > 86400000L) {
                return after / 86400000L + this.hint.dayFuture;
            }
            if (after > 3600000L) {
                return after / 3600000L + this.hint.hourFuture;
            }
            if (after > 60000L) {
                return after / 60000L + this.hint.minuteFuture;
            }
            return this.vague ? this.hint.moment : after / 1000L + this.hint.secondFuture;
        }
        return this.vague ? this.hint.now : 0 + this.hint.secondAgo;
    }
}

