/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define;

import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.math.Numbers;
import cn.orionsec.kit.lang.utils.time.Dates;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private long from;
    private long to;
    private boolean nano;
    private List<StopTag> tags;
    private StopTag lastTag;

    public StopWatch() {
    }

    public StopWatch(boolean nano) {
        this.nano = nano;
    }

    public static StopWatch begin() {
        StopWatch sw = new StopWatch();
        sw.start();
        return sw;
    }

    public static StopWatch begin(boolean nano) {
        StopWatch sw = new StopWatch(nano);
        sw.start();
        return sw;
    }

    public static StopWatch create() {
        return new StopWatch();
    }

    public static StopWatch create(boolean nano) {
        return new StopWatch(nano);
    }

    public static StopWatch run(Runnable r) {
        StopWatch sw = StopWatch.begin();
        r.run();
        sw.stop();
        return sw;
    }

    public static StopWatch run(Runnable r, boolean nano) {
        StopWatch sw = new StopWatch(nano);
        r.run();
        sw.stop();
        return sw;
    }

    public long start() {
        this.to = this.from = this.current();
        return this.from;
    }

    public long stop() {
        this.to = this.current();
        return this.to;
    }

    public long getDuration() {
        return this.to - this.from;
    }

    public boolean isNano() {
        return this.nano;
    }

    public long getStartTime() {
        return this.from;
    }

    public long getEndTime() {
        return this.to;
    }

    private String getUse(StopTag tag) {
        return Numbers.setScale((double)tag.getDuration() / (double)(this.to - this.from) * 100.0, 6);
    }

    private long current() {
        return this.nano ? System.nanoTime() : System.currentTimeMillis();
    }

    public StopTag tag() {
        return this.tag(null);
    }

    public StopTag tag(String name) {
        if (this.tags == null) {
            this.tags = new LinkedList<StopTag>();
        }
        this.lastTag = new StopTag(name, this.current(), this.lastTag);
        this.tags.add(this.lastTag);
        return this.lastTag;
    }

    public StopTag tag(String tpl, Object ... args) {
        return this.tag(Strings.format(tpl, args));
    }

    public String toString() {
        String prefix = String.format("Total: %d%s; [%s] => [%s]", this.getDuration(), this.nano ? "ns" : "ms", this.nano ? Long.valueOf(this.from) : Dates.format(new Date(this.from), "HH:mm:ss.SSS"), this.nano ? Long.valueOf(this.to) : Dates.format(new Date(this.to), "HH:mm:ss.SSS"));
        if (this.tags == null) {
            return prefix;
        }
        StringBuilder sb = new StringBuilder(prefix).append("\n");
        for (int i = 0; i < this.tags.size(); ++i) {
            StopTag tag = this.tags.get(i);
            sb.append(String.format("  -> %4s: %d%s  %4s%%", tag.name == null ? "TAG" + i : tag.name, tag.getDuration(), this.nano ? "ns" : "ms", this.getUse(tag)));
            if (i >= this.tags.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public class StopTag {
        private String name;
        private long tm;
        private StopTag pre;

        public StopTag(String name, long tm, StopTag pre) {
            this.name = name;
            this.tm = tm;
            this.pre = pre;
        }

        public long getDuration() {
            if (this.pre == null) {
                return this.tm - StopWatch.this.from;
            }
            return this.tm - this.pre.tm;
        }

        private long getStart() {
            if (this.pre == null) {
                return StopWatch.this.from;
            }
            return this.pre.tm;
        }

        public String getName() {
            return this.name;
        }

        public long getTm() {
            return this.tm;
        }

        public StopTag getPre() {
            return this.pre;
        }

        public String toString() {
            return String.format("%s: [%d] => [%s] %2d%s", this.name == null ? "TAG" : this.name, this.getStart(), this.tm, this.getDuration(), StopWatch.this.nano ? "ns" : "ms");
        }
    }
}

