/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.able.Buildable;
import cn.orionsec.kit.lang.define.cache.TimedCache;
import java.util.function.BiConsumer;

public class TimedCacheBuilder
implements Buildable<TimedCache> {
    private static final int CHECK_DELAY = 5000;
    private int expiredDelay;
    private int checkDelay = 5000;
    private BiConsumer<String, Object> expiredListener;

    private TimedCacheBuilder() {
    }

    public static TimedCacheBuilder create() {
        return new TimedCacheBuilder();
    }

    public static TimedCache create(int expired) {
        return new TimedCache(expired, 5000, null);
    }

    public static TimedCache create(int expired, int checkDelay) {
        return new TimedCache(expired, checkDelay, null);
    }

    public TimedCacheBuilder expiredDelay(int expiredDelay) {
        this.expiredDelay = expiredDelay;
        return this;
    }

    public TimedCacheBuilder checkDelay(int checkDelay) {
        this.checkDelay = checkDelay;
        return this;
    }

    public TimedCacheBuilder expiredListener(BiConsumer<String, Object> expiredListener) {
        this.expiredListener = expiredListener;
        return this;
    }

    @Override
    public TimedCache build() {
        return new TimedCache(this.expiredDelay, this.checkDelay, this.expiredListener);
    }
}

