/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.define.collect.MultiMap;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class MultiLinkedHashMap<K, V, E>
extends LinkedHashMap<K, LinkedHashMap<V, E>>
implements MultiMap<K, V, E, LinkedHashMap<V, E>>,
Serializable {
    private static final long serialVersionUID = 1237895897912782748L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int valueInitialCapacity;
    private float valueLoadFactor;
    private boolean valueAccessOrder;

    public MultiLinkedHashMap() {
        this(16, 0.75f, false);
    }

    public MultiLinkedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, false);
    }

    public MultiLinkedHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public MultiLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.valueInitialCapacity = initialCapacity;
        this.valueLoadFactor = loadFactor;
        this.valueAccessOrder = accessOrder;
    }

    public static <K, V, E> MultiLinkedHashMap<K, V, E> create() {
        return new MultiLinkedHashMap<K, V, E>();
    }

    public static <K, V, E> MultiLinkedHashMap<K, V, E> create(int initialCapacity, float loadFactor, boolean accessOrder) {
        return new MultiLinkedHashMap<K, V, E>(initialCapacity, loadFactor, accessOrder);
    }

    public void valueCapacity(int valueInitialCapacity) {
        this.valueCapacity(valueInitialCapacity, 0.75f, false);
    }

    public void valueCapacity(int valueInitialCapacity, float valueLoadFactor) {
        this.valueCapacity(valueInitialCapacity, valueLoadFactor, false);
    }

    public void valueCapacity(int valueInitialCapacity, float valueLoadFactor, boolean valueAccessOrder) {
        this.valueInitialCapacity = valueInitialCapacity;
        this.valueLoadFactor = valueLoadFactor;
        this.valueAccessOrder = valueAccessOrder;
    }

    @Override
    public LinkedHashMap<V, E> computeSpace(K e) {
        return super.computeIfAbsent(e, k -> new LinkedHashMap(this.valueInitialCapacity, this.valueLoadFactor, this.valueAccessOrder));
    }
}

