/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.io;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.function.Consumer;

public class WriterAppender
extends Writer
implements Iterable<WriterAppender> {
    private final Writer writer;
    private WriterAppender prev;
    private WriterAppender next;
    private boolean closeOnClose;

    public WriterAppender(Writer writer) {
        this.writer = writer;
        this.closeOnClose = true;
    }

    public static WriterAppender create(Writer writer) {
        return new WriterAppender(writer);
    }

    public WriterAppender then(Writer writer) {
        WriterAppender appender = new WriterAppender(writer);
        appender.prev = this;
        this.next = appender;
        return appender;
    }

    public WriterAppender onClose(boolean onClose) {
        this.closeOnClose = onClose;
        return this;
    }

    public WriterAppender getRoot() {
        return this.findPrev(this);
    }

    private WriterAppender findPrev(WriterAppender appender) {
        if (appender.prev == null) {
            return appender;
        }
        return this.findPrev(appender.prev);
    }

    public void handle(Consumer<Writer> c) {
        for (WriterAppender appender : this) {
            c.accept(appender.writer);
        }
    }

    @Override
    public void write(int b) throws IOException {
        for (WriterAppender appender : this) {
            appender.writer.write(b);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public void close() {
        for (WriterAppender appender : this) {
            if (!appender.closeOnClose) continue;
            Streams.close(appender.writer);
        }
    }

    @Override
    public void flush() {
        for (WriterAppender appender : this) {
            Streams.flush(appender.writer);
        }
    }

    @Override
    public Iterator<WriterAppender> iterator() {
        return new WriterAppenderIterator(this.getRoot());
    }

    public Writer getWriter() {
        return this.writer;
    }

    static class WriterAppenderIterator
    implements Iterator<WriterAppender> {
        private WriterAppender current;

        private WriterAppenderIterator(WriterAppender current) {
            this.current = current;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public WriterAppender next() {
            if (this.current == null) {
                throw Exceptions.noSuchElement("there are no more elements");
            }
            WriterAppender tmp = this.current;
            this.current = this.current.next;
            return tmp;
        }
    }
}

