/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.define.Null;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.collect.Maps;
import cn.orionsec.kit.lang.utils.hash.Hashes;
import cn.orionsec.kit.lang.utils.reflect.Methods;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Objects1 {
    private Objects1() {
    }

    public static <T> T def(T o, T def) {
        if (Objects1.isNull(o)) {
            return def;
        }
        return o;
    }

    public static <T> T def(T o, Supplier<T> supplier) {
        if (Objects1.isNull(o)) {
            return supplier.get();
        }
        return o;
    }

    public static <T, R> R map(T o, Function<T, R> f) {
        if (!Objects1.isNull(o)) {
            return f.apply(o);
        }
        return null;
    }

    public static <T> void ifNotNull(T o, Consumer<T> acceptor) {
        if (!Objects1.isNull(o)) {
            acceptor.accept(o);
        }
    }

    public static <T> void ifTrue(T o, Predicate<T> tester, Consumer<T> acceptor) {
        if (tester.test(o)) {
            acceptor.accept(o);
        }
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Arrays1.arrayEquals(o1, o2);
        }
        return false;
    }

    @SafeVarargs
    public static <T> T firstNotNull(T ... values) {
        if (values != null) {
            for (T val : values) {
                if (val == null) continue;
                return val;
            }
        }
        return null;
    }

    public static boolean isNull(Object o) {
        return o == null;
    }

    public static boolean isNotNull(Object o) {
        return o != null;
    }

    public static boolean isNulls(Object o) {
        return o == null || o == Null.VALUE;
    }

    public static boolean isNotNulls(Object o) {
        return o != null && o != Null.VALUE;
    }

    public static boolean isAllNull(Object ... o) {
        if (o == null) {
            return true;
        }
        for (Object o1 : o) {
            if (o1 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneNull(Object ... o) {
        if (o == null) {
            return false;
        }
        for (Object o1 : o) {
            if (o1 != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof Collection) {
            return Lists.isEmpty((Collection)o);
        }
        if (o instanceof Map) {
            return Maps.isEmpty((Map)o);
        }
        if (o instanceof String) {
            return Strings.isBlank((String)o);
        }
        return false;
    }

    public static boolean isNotEmpty(Object o) {
        return !Objects1.isEmpty(o);
    }

    public static boolean isAllEmpty(Object ... o) {
        if (o == null) {
            return true;
        }
        for (Object o1 : o) {
            if (!Objects1.isNotEmpty(o1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNoneEmpty(Object ... o) {
        if (o == null) {
            return false;
        }
        for (Object o1 : o) {
            if (!Objects1.isEmpty(o1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isVoids(Class<?> c) {
        return Void.TYPE.equals(c) || Void.class.equals(c);
    }

    public static boolean isNotVoids(Class<?> c) {
        return !Objects1.isVoids(c);
    }

    public static <T> T clone(T o) {
        if (o == null) {
            return null;
        }
        if (Arrays1.isArray(o)) {
            return Objects1.deserialize(Objects1.serialize((Serializable)o));
        }
        if (o.getClass() != Object.class && o instanceof Cloneable) {
            return (T)Methods.invokeMethod(o, "clone");
        }
        if (o instanceof Serializable) {
            return Objects1.deserialize(Objects1.serialize((Serializable)o));
        }
        throw Exceptions.argument("Failed to serialize object, not implements Cloneable and not implements Serializable");
    }

    /*
     * Exception decompiling
     */
    public static <T extends Serializable> byte[] serialize(T o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw Exceptions.argument("failed to deserialize object", e);
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.toString((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.toString((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.toString((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.toString((long[])o);
        }
        if (o instanceof float[]) {
            return Arrays.toString((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.toString((double[])o);
        }
        if (o instanceof char[]) {
            return Arrays.toString((char[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.toString((boolean[])o);
        }
        return Objects1.def(o.toString(), "");
    }

    public static String getObjectIdentity(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.getClass().getName() + "@" + Objects1.getIdentity(obj);
    }

    public static String getIdentity(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }

    public static int hashCode(Object obj) {
        return Hashes.hashCode(obj);
    }
}

