/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ansi.cursor;

import cn.orionsec.kit.lang.utils.ansi.AnsiElement;

public class AnsiCursor
implements AnsiElement {
    private final String code;

    public AnsiCursor(String code) {
        this.code = code;
    }

    public static AnsiCursor up() {
        return new AnsiCursor("A");
    }

    public static AnsiCursor up(int line) {
        return new AnsiCursor(line + "A");
    }

    public static AnsiCursor down() {
        return new AnsiCursor("B");
    }

    public static AnsiCursor down(int line) {
        return new AnsiCursor(line + "B");
    }

    public static AnsiCursor right() {
        return new AnsiCursor("C");
    }

    public static AnsiCursor right(int line) {
        return new AnsiCursor(line + "C");
    }

    public static AnsiCursor left() {
        return new AnsiCursor("D");
    }

    public static AnsiCursor left(int line) {
        return new AnsiCursor(line + "D");
    }

    public static AnsiCursor next() {
        return new AnsiCursor("E");
    }

    public static AnsiCursor next(int line) {
        return new AnsiCursor(line + "E");
    }

    public static AnsiCursor prev() {
        return new AnsiCursor("F");
    }

    public static AnsiCursor prev(int line) {
        return new AnsiCursor(line + "F");
    }

    public static AnsiCursor column() {
        return new AnsiCursor("G");
    }

    public static AnsiCursor column(int column) {
        return new AnsiCursor(column + "G");
    }

    public static AnsiCursor forwardTab() {
        return new AnsiCursor("I");
    }

    public static AnsiCursor forwardTab(int tab) {
        return new AnsiCursor(tab + "I");
    }

    public static AnsiCursor backwardTab() {
        return new AnsiCursor("Z");
    }

    public static AnsiCursor backwardTab(int tab) {
        return new AnsiCursor(tab + "Z");
    }

    public static AnsiCursor line(int line) {
        return new AnsiCursor(line + ";" + "H");
    }

    public static AnsiCursor reset() {
        return new AnsiCursor(";H");
    }

    public static AnsiCursor move(int line, int column) {
        return new AnsiCursor(line + ";" + column + "H");
    }

    public static AnsiCursor mark() {
        return new AnsiCursor("s");
    }

    public static AnsiCursor resume() {
        return new AnsiCursor("u");
    }

    public static AnsiCursor report() {
        return new AnsiCursor("6n");
    }

    @Override
    public String toString() {
        return "\u001b[" + this.code;
    }
}

