/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.awt;

import cn.orionsec.kit.lang.utils.Exceptions;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class Clipboards {
    private Clipboards() {
    }

    public static Clipboard getClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    public static void set(Transferable contents) {
        Clipboards.set(contents, null);
    }

    public static void set(Transferable contents, ClipboardOwner owner) {
        Clipboards.getClipboard().setContents(contents, owner);
    }

    public static Object get(DataFlavor flavor) {
        return Clipboards.get(Clipboards.getClipboard().getContents(null), flavor);
    }

    public static Object get(Transferable content, DataFlavor flavor) {
        if (content != null && content.isDataFlavorSupported(flavor)) {
            try {
                return content.getTransferData(flavor);
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw Exceptions.runtime(e);
            }
        }
        return null;
    }

    public static void setString(String text) {
        Clipboards.set(new StringSelection(text));
    }

    public static String getString() {
        return (String)Clipboards.get(DataFlavor.stringFlavor);
    }

    public static String getString(Transferable content) {
        return (String)Clipboards.get(content, DataFlavor.stringFlavor);
    }
}

