/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.code;

import cn.orionsec.kit.lang.utils.Colors;
import cn.orionsec.kit.lang.utils.awt.Images;
import cn.orionsec.kit.lang.utils.codec.Base64s;
import cn.orionsec.kit.lang.utils.io.Streams;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public abstract class CodeGenerator {
    protected static final MultiFormatWriter WRITER = new MultiFormatWriter();
    protected BarcodeFormat format;
    protected String suffix = "png";
    protected String charset = "UTF-8";
    protected int width;
    protected int height;
    protected int errorCorrectionLevel = 1;
    protected Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18);
    protected Color fontColor = Color.BLACK;
    protected int imgTopMargin;
    protected int imgButtonMargin;
    protected int wordsTopMargin;
    protected int wordsButtonMargin = 10;
    protected Map<EncodeHintType, Object> encodeHint = new HashMap<EncodeHintType, Object>(8);
    protected Map<DecodeHintType, Object> decodeHint = new HashMap<DecodeHintType, Object>(8);

    protected CodeGenerator() {
        this.encodeHint.put(EncodeHintType.ERROR_CORRECTION, this.toErrorCorrectionLevel());
        this.encodeHint.put(EncodeHintType.CHARACTER_SET, this.charset);
        this.encodeHint.put(EncodeHintType.MARGIN, 1);
        this.decodeHint.put(DecodeHintType.CHARACTER_SET, this.charset);
    }

    protected ErrorCorrectionLevel toErrorCorrectionLevel() {
        if (this.errorCorrectionLevel <= 1) {
            return ErrorCorrectionLevel.L;
        }
        if (this.errorCorrectionLevel == 2) {
            return ErrorCorrectionLevel.M;
        }
        if (this.errorCorrectionLevel == 3) {
            return ErrorCorrectionLevel.Q;
        }
        return ErrorCorrectionLevel.H;
    }

    protected abstract BufferedImage getBufferedImage(String var1);

    protected BufferedImage insertWords(BufferedImage image, String words) {
        int fontSize = this.font.getSize();
        int newHeight = this.imgTopMargin + this.height + this.imgButtonMargin + this.wordsTopMargin + fontSize + this.wordsButtonMargin;
        BufferedImage outImage = new BufferedImage(this.width, newHeight, 1);
        Graphics2D g2d = outImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(s);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, newHeight);
        g2d.drawImage(image, 0, this.imgTopMargin, image.getWidth(), image.getHeight(), null);
        g2d.setColor(this.fontColor);
        g2d.setFont(this.font);
        int strWidth = g2d.getFontMetrics().stringWidth(words);
        int wordStartX = (this.width - strWidth) / 2;
        int wordStartY = this.imgTopMargin + this.height + this.imgButtonMargin + this.wordsTopMargin + fontSize;
        g2d.drawString(words, wordStartX, wordStartY);
        g2d.dispose();
        outImage.flush();
        return outImage;
    }

    public CodeGenerator encodeHint(Map<EncodeHintType, Object> encodeHint) {
        this.encodeHint = encodeHint;
        return this;
    }

    public CodeGenerator decodeHint(Map<DecodeHintType, Object> decodeHint) {
        this.decodeHint = decodeHint;
        return this;
    }

    public CodeGenerator encodeHint(EncodeHintType type, Object hint) {
        this.encodeHint.put(type, hint);
        return this;
    }

    public CodeGenerator decodeHint(DecodeHintType type, Object hint) {
        this.decodeHint.put(type, hint);
        return this;
    }

    public void encode(String content, OutputStream out) {
        this.encode(content, null, out);
    }

    public byte[] encode(String content) {
        return this.encode(content, (String)null);
    }

    public byte[] encode(String content, String words) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encode(content, words, out);
        return out.toByteArray();
    }

    public String encodeBase64(String content) {
        return Base64s.imgEncode(this.encode(content, (String)null), this.suffix);
    }

    public String encodeBase64(String content, String words) {
        return Base64s.imgEncode(this.encode(content, words), this.suffix);
    }

    public abstract void encode(String var1, String var2, OutputStream var3);

    public String decode(String file) {
        try {
            return this.decode(ImageIO.read(new File(file)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String decode(File file) {
        try {
            return this.decode(ImageIO.read(file));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String decode(byte[] bs) {
        try {
            return this.decode(ImageIO.read(Streams.toInputStream(bs)));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String decode(InputStream in) {
        try {
            return this.decode(ImageIO.read(in));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String decodeBase64(String base64) {
        return this.decode(Images.base64Decode(base64));
    }

    public String decode(BufferedImage image) {
        try {
            image = image.getSubimage(0, this.imgTopMargin, this.width, this.height);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            return new MultiFormatReader().decode(bitmap, this.getDecodeHint()).getText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public CodeGenerator format(BarcodeFormat format) {
        this.format = format;
        return this;
    }

    public CodeGenerator suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public CodeGenerator charset(String charset) {
        this.charset = charset;
        return this;
    }

    public CodeGenerator errorCorrectionLevel(int errorCorrectionLevel) {
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.encodeHint.put(EncodeHintType.ERROR_CORRECTION, this.toErrorCorrectionLevel());
        return this;
    }

    public CodeGenerator width(int width) {
        this.width = width;
        return this;
    }

    public CodeGenerator height(int height) {
        this.height = height;
        return this;
    }

    public CodeGenerator size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public CodeGenerator wordsTopMargin(int wordsTopMargin) {
        this.wordsTopMargin = wordsTopMargin;
        return this;
    }

    public CodeGenerator wordsButtonMargin(int wordsButtonMargin) {
        this.wordsButtonMargin = wordsButtonMargin;
        return this;
    }

    public CodeGenerator wordsMargin(int wordsTopMargin, int wordsButtonMargin) {
        this.wordsTopMargin = wordsTopMargin;
        this.wordsButtonMargin = wordsButtonMargin;
        return this;
    }

    public CodeGenerator imgTopMargin(int imgTopMargin) {
        this.imgTopMargin = imgTopMargin;
        return this;
    }

    public CodeGenerator imgButtonMargin(int imgButtonMargin) {
        this.imgButtonMargin = imgButtonMargin;
        return this;
    }

    public CodeGenerator imgMargin(int imgTopMargin, int imgButtonMargin) {
        this.imgTopMargin = imgTopMargin;
        this.imgButtonMargin = imgButtonMargin;
        return this;
    }

    public CodeGenerator font(Font font) {
        this.font = font;
        return this;
    }

    public CodeGenerator font(String name) {
        this.font = new Font(name, 0, 18);
        return this;
    }

    public CodeGenerator font(int size) {
        this.font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, size);
        return this;
    }

    public CodeGenerator font(String name, int size) {
        this.font = new Font(name, 0, size);
        return this;
    }

    public CodeGenerator fontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public CodeGenerator fontColor(String hexColor) {
        this.fontColor = Colors.toColor(hexColor);
        return this;
    }

    public BarcodeFormat getFormat() {
        return this.format;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public int getImgTopMargin() {
        return this.imgTopMargin;
    }

    public int getImgButtonMargin() {
        return this.imgButtonMargin;
    }

    public int getWordsTopMargin() {
        return this.wordsTopMargin;
    }

    public int getWordsButtonMargin() {
        return this.wordsButtonMargin;
    }

    public Map<EncodeHintType, Object> getEncodeHint() {
        return this.encodeHint;
    }

    public Map<DecodeHintType, Object> getDecodeHint() {
        return this.decodeHint;
    }
}

