/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.code;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.code.CodeGenerator;
import cn.orionsec.kit.lang.utils.io.Streams;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.BitMatrix;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class QRCodes
extends CodeGenerator {
    private int logoWidth;
    private int logoHeight;
    private Image logo;
    private boolean logoCompress;

    public QRCodes() {
        this.format = BarcodeFormat.QR_CODE;
        this.width = 300;
        this.height = 300;
        this.logoWidth = 60;
        this.logoHeight = 60;
        this.wordsTopMargin = -5;
        this.wordsButtonMargin = 10;
    }

    public QRCodes logoCompress() {
        this.logoCompress = true;
        if (this.logo != null) {
            int width = this.logo.getWidth(null);
            int height = this.logo.getHeight(null);
            if (width > this.logoWidth) {
                width = this.logoWidth;
            }
            if (height > this.logoHeight) {
                height = this.logoHeight;
            }
            Image image = this.logo.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            this.logo = image;
        }
        return this;
    }

    @Override
    protected BufferedImage getBufferedImage(String content) {
        try {
            BitMatrix bitMatrix = WRITER.encode(content, this.format, this.width, this.height, this.getEncodeHint());
            BufferedImage image = new BufferedImage(this.width, this.height, 1);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            return image;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void insertLogo(BufferedImage source) {
        int w = this.logo.getWidth(null);
        int h = this.logo.getHeight(null);
        Graphics2D graph = source.createGraphics();
        int x = (this.width - w) / 2;
        int y = (this.height - h) / 2;
        graph.drawImage(this.logo, x, y, w, h, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, w, w, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
        source.flush();
    }

    @Override
    public void encode(String content, String words, OutputStream out) {
        try {
            BufferedImage image = this.getBufferedImage(content);
            if (this.logo != null) {
                this.insertLogo(image);
            }
            if (!Strings.isBlank(words)) {
                image = this.insertWords(image, words);
            }
            ImageIO.write((RenderedImage)image, this.suffix, out);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    @Override
    public QRCodes width(int width) {
        return this.size(width);
    }

    @Override
    public QRCodes height(int height) {
        return this.size(height);
    }

    @Override
    public QRCodes size(int width, int height) {
        return this.size(width);
    }

    public QRCodes size(int size) {
        this.width = size;
        this.height = size;
        return this;
    }

    public QRCodes logoWidth(int logoWidth) {
        this.logoWidth = logoWidth;
        return this;
    }

    public QRCodes logoHeight(int logoHeight) {
        this.logoHeight = logoHeight;
        return this;
    }

    public QRCodes logoSize(int size) {
        this.logoWidth = size;
        this.logoHeight = size;
        return this;
    }

    public QRCodes logo(String file) {
        try {
            return this.logo(ImageIO.read(new File(file)));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public QRCodes logo(File file) {
        try {
            return this.logo(ImageIO.read(file));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public QRCodes logo(InputStream in) {
        try {
            return this.logo(ImageIO.read(in));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public QRCodes logo(byte[] bs) {
        try {
            return this.logo(ImageIO.read(Streams.toInputStream(bs)));
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public QRCodes logo(Image logo) {
        this.logo = logo;
        if (this.logoCompress) {
            this.logoCompress();
        }
        this.errorCorrectionLevel = 4;
        this.encodeHint.put(EncodeHintType.ERROR_CORRECTION, this.toErrorCorrectionLevel());
        return this;
    }

    public int getLogoWidth() {
        return this.logoWidth;
    }

    public int getLogoHeight() {
        return this.logoHeight;
    }

    public Image getLogo() {
        return this.logo;
    }

    public boolean isLogoCompress() {
        return this.logoCompress;
    }
}

