/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.codec;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Strings;
import java.util.Base64;

public class Base64s {
    private Base64s() {
    }

    public static String encode(String s) {
        return new String(Base64.getEncoder().encode(Strings.bytes(s)));
    }

    public static byte[] encodeToBytes(String s) {
        return Base64.getEncoder().encode(Strings.bytes(s));
    }

    public static byte[] encode(byte[] b) {
        return Base64.getEncoder().encode(b);
    }

    public static String encodeToString(byte[] b) {
        return new String(Base64.getEncoder().encode(b));
    }

    public static String decode(String s) {
        return new String(Base64.getDecoder().decode(s));
    }

    public static byte[] decodeToBytes(String s) {
        return Base64.getDecoder().decode(s);
    }

    public static byte[] decode(byte[] b) {
        return Base64.getDecoder().decode(b);
    }

    public static String decodeToString(byte[] b) {
        return new String(Base64.getDecoder().decode(b));
    }

    public static String mimeTypeEncode(String s, String mimeType) {
        return Base64s.mimeTypeEncode(Strings.bytes(s), mimeType);
    }

    public static String mimeTypeEncode(byte[] bs, String mimeType) {
        return "data:" + mimeType + ";base64," + Base64s.encodeToString(bs);
    }

    public static byte[] mimeTypeDecode(String s) {
        String[] b = s.split(",");
        return Base64s.decode(Strings.bytes(Arrays1.last(b)));
    }

    public static String getMimeType(String s) {
        String[] b = s.split(",");
        if (b.length == 0) {
            return "";
        }
        return b[0].split(";")[0];
    }

    public static String getMimeTypeFirst(String s) {
        return Arrays1.first(Base64s.getMimeType(s).split("/"));
    }

    public static String getMimeTypeLast(String s) {
        return Arrays1.last(Base64s.getMimeType(s).split("/"));
    }

    public static String imgEncode(byte[] bs) {
        return Base64s.imgEncode(bs, "png");
    }

    public static String imgEncode(byte[] bs, String type) {
        return Base64s.mimeTypeEncode(bs, "image/" + type);
    }

    public static String url64Encode(String s) {
        return new String(Base64.getUrlEncoder().encode(Strings.bytes(s)));
    }

    public static byte[] url64EncodeToBytes(String s) {
        return Base64.getUrlEncoder().encode(Strings.bytes(s));
    }

    public static byte[] url64Encode(byte[] b) {
        return Base64.getUrlEncoder().encode(b);
    }

    public static String url64EncodeToString(byte[] b) {
        return new String(Base64.getUrlEncoder().encode(b));
    }

    public static String url64Decode(String s) {
        return new String(Base64.getUrlDecoder().decode(s));
    }

    public static byte[] url64DecodeToBytes(String s) {
        return Base64.getUrlDecoder().decode(s);
    }

    public static byte[] url64Decode(byte[] b) {
        return Base64.getUrlDecoder().decode(b);
    }

    public static String url64DecodeToString(byte[] b) {
        return new String(Base64.getUrlDecoder().decode(b));
    }
}

