/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.convert;

import cn.orionsec.kit.lang.function.Conversion;
import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Objects1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.convert.TypeStore;
import cn.orionsec.kit.lang.utils.time.Dates;
import cn.orionsec.kit.lang.utils.time.Dates8;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class Converts {
    private Converts() {
    }

    public static <T, R> R to(T t, Class<R> targetClass) {
        return TypeStore.STORE.to(t, targetClass);
    }

    public static <T, R> Conversion<T, R> to(Class<R> targetClass) {
        return t -> Converts.to(t, targetClass);
    }

    public static <T, R> R to(T t, Conversion<T, R> f) {
        return f.apply(t);
    }

    public static <T, R> List<R> toList(List<T> list, Class<R> targetClass) {
        return list.stream().map(s -> Converts.to(s, targetClass)).collect(Collectors.toList());
    }

    public static String toString(Object o) {
        return Objects1.toString(o);
    }

    public static Date toDate(Object o) {
        if (o == null) {
            return null;
        }
        Date date = Dates.date(o);
        if (date == null) {
            throw Exceptions.convert(Strings.format("unable to convert [{}: {}] to [Date]", o.getClass().getName(), o.toString()));
        }
        return date;
    }

    public static LocalDate toLocalDate(Object o) {
        if (o == null) {
            return null;
        }
        LocalDate date = Dates8.localDate(o);
        if (date == null) {
            throw Exceptions.convert(Strings.format("unable to convert [{}: {}] to [LocalDate]", o.getClass().getName(), o.toString()));
        }
        return date;
    }

    public static LocalDateTime toLocalDateTime(Object o) {
        if (o == null) {
            return null;
        }
        LocalDateTime date = Dates8.localDateTime(o);
        if (date == null) {
            throw Exceptions.convert(Strings.format("unable to convert [{}: {}] to [LocalDateTime]", o.getClass().getName(), o.toString()));
        }
        return date;
    }

    public static byte toByte(Byte b) {
        return b;
    }

    public static byte toByte(short b) {
        return (byte)b;
    }

    public static byte toByte(int b) {
        return (byte)b;
    }

    public static byte toByte(long b) {
        return (byte)b;
    }

    public static byte toByte(float b) {
        return (byte)b;
    }

    public static byte toByte(double b) {
        return (byte)b;
    }

    public static byte toByte(boolean b) {
        return (byte)(b ? 1 : 0);
    }

    public static byte toByte(char b) {
        return (byte)b;
    }

    public static byte toByte(String b) {
        return Byte.valueOf(b);
    }

    public static byte toByte(Object o) {
        Valid.notNull(o);
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Boolean) {
            return (byte)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Character) {
            return (byte)((Character)o).charValue();
        }
        if (o instanceof String) {
            return Byte.valueOf((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [byte]", o.getClass().getName()));
    }

    public static short toShort(byte[] b) {
        if (b.length == 2) {
            short s0 = (short)(b[0] & 0xFF);
            short s1 = (short)(b[1] & 0xFF);
            s1 = (short)(s1 << 8);
            return (short)(s0 | s1);
        }
        if (b.length == 4) {
            return (short)Converts.toInt(b);
        }
        if (b.length == 8) {
            return (short)Converts.toLong(b);
        }
        throw Exceptions.convert("array length must 2 or 4 or 8");
    }

    public static short toShort(byte b) {
        return b;
    }

    public static short toShort(Short b) {
        return b;
    }

    public static short toShort(int b) {
        return (short)b;
    }

    public static short toShort(long b) {
        return (short)b;
    }

    public static short toShort(float b) {
        return (short)b;
    }

    public static short toShort(double b) {
        return (short)b;
    }

    public static short toShort(boolean b) {
        return (short)(b ? 1 : 0);
    }

    public static short toShort(char b) {
        return (short)b;
    }

    public static short toShort(String b) {
        return Short.valueOf(b);
    }

    public static short toShort(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toShort((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toShort(Arrays1.unWrap((Byte[])o));
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Boolean) {
            return (short)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Character) {
            return (short)((Character)o).charValue();
        }
        if (o instanceof String) {
            return Short.valueOf((String)o);
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [short]", o.getClass().getName()));
    }

    public static int toInt(byte[] bs) {
        if (bs.length == 2) {
            return Converts.toShort(bs);
        }
        if (bs.length == 4) {
            int num = bs[0] & 0xFF;
            num |= bs[1] << 8 & 0xFF00;
            num |= bs[2] << 16 & 0xFF0000;
            return num |= bs[3] << 24 & 0xFF000000;
        }
        if (bs.length == 8) {
            return (int)Converts.toLong(bs);
        }
        throw Exceptions.convert("array length must 2 or 4 or 8");
    }

    public static int toInt(byte b) {
        return b;
    }

    public static int toInt(short b) {
        return b;
    }

    public static int toInt(Integer b) {
        return b;
    }

    public static int toInt(long b) {
        return (int)b;
    }

    public static int toInt(float b) {
        return (int)b;
    }

    public static int toInt(double b) {
        return (int)b;
    }

    public static int toInt(boolean b) {
        return b ? 1 : 0;
    }

    public static int toInt(char b) {
        return b;
    }

    public static int toInt(String b) {
        return Integer.parseInt(b);
    }

    public static int toInt(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toInt((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toInt(Arrays1.unWrap((Byte[])o));
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [int]", o.getClass().getName()));
    }

    public static long toLong(byte[] b) {
        if (b.length == 2) {
            return Converts.toShort(b);
        }
        if (b.length == 4) {
            return Converts.toInt(b);
        }
        if (b.length == 8) {
            long s0 = b[0] & 0xFF;
            long s1 = b[1] & 0xFF;
            long s2 = b[2] & 0xFF;
            long s3 = b[3] & 0xFF;
            long s4 = b[4] & 0xFF;
            long s5 = b[5] & 0xFF;
            long s6 = b[6] & 0xFF;
            long s7 = b[7] & 0xFF;
            return s0 | (s1 <<= 8) | (s2 <<= 16) | (s3 <<= 24) | (s4 <<= 32) | (s5 <<= 40) | (s6 <<= 48) | (s7 <<= 56);
        }
        throw Exceptions.convert("array length must 4 or 8");
    }

    public static long toLong(byte b) {
        return b;
    }

    public static long toLong(short b) {
        return b;
    }

    public static long toLong(int b) {
        return b;
    }

    public static long toLong(Long b) {
        return b;
    }

    public static long toLong(float b) {
        return (long)b;
    }

    public static long toLong(double b) {
        return (long)b;
    }

    public static long toLong(boolean b) {
        return b ? 1L : 0L;
    }

    public static long toLong(char b) {
        return b;
    }

    public static long toLong(String b) {
        return Long.parseLong(b);
    }

    public static long toLong(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toLong((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toLong(Arrays1.unWrap((Byte[])o));
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [long]", o.getClass().getName()));
    }

    public static float toFloat(byte b) {
        return b;
    }

    public static float toFloat(short b) {
        return b;
    }

    public static float toFloat(int b) {
        return b;
    }

    public static float toFloat(long b) {
        return b;
    }

    public static float toFloat(Float b) {
        return b.floatValue();
    }

    public static float toFloat(double b) {
        return (float)b;
    }

    public static float toFloat(boolean b) {
        return b ? 1 : 0;
    }

    public static float toFloat(char b) {
        return b;
    }

    public static float toFloat(String b) {
        return Float.valueOf(b).floatValue();
    }

    public static float toFloat(Object o) {
        Valid.notNull(o);
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            return Float.parseFloat((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [float]", o.getClass().getName()));
    }

    public static double toDouble(byte b) {
        return b;
    }

    public static double toDouble(short b) {
        return b;
    }

    public static double toDouble(int b) {
        return b;
    }

    public static double toDouble(long b) {
        return b;
    }

    public static double toDouble(float b) {
        return b;
    }

    public static double toDouble(Double b) {
        return b;
    }

    public static double toDouble(boolean b) {
        return b ? 1.0 : 0.0;
    }

    public static double toDouble(char b) {
        return b;
    }

    public static double toDouble(String b) {
        return Double.valueOf(b);
    }

    public static double toDouble(Object o) {
        Valid.notNull(o);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [double]", o.getClass().getName()));
    }

    public static boolean toBoolean(byte b) {
        return b != 0;
    }

    public static boolean toBoolean(short b) {
        return b != 0;
    }

    public static boolean toBoolean(int b) {
        return b != 0;
    }

    public static boolean toBoolean(long b) {
        return b != 0L;
    }

    public static boolean toBoolean(float b) {
        return b != 0.0f;
    }

    public static boolean toBoolean(double b) {
        return b != 0.0;
    }

    public static boolean toBoolean(Boolean b) {
        return Boolean.TRUE.equals(b);
    }

    public static boolean toBoolean(char b) {
        return b != '\u0000';
    }

    public static boolean toBoolean(String b) {
        return Strings.isNotBlank(b) && "true".equalsIgnoreCase(b.trim());
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Byte) {
            return (Byte)o != 0;
        }
        if (o instanceof Short) {
            return (Short)o != 0;
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        if (o instanceof Long) {
            return (Long)o != 0L;
        }
        if (o instanceof Float) {
            return !Float.isNaN(((Float)o).floatValue()) && ((Float)o).floatValue() != 0.0f;
        }
        if (o instanceof Double) {
            return !Double.isNaN((Double)o) && (Double)o != 0.0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Character) {
            return ((Character)o).charValue() != '\u0000';
        }
        if (o instanceof String) {
            return Converts.toBoolean((String)o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [boolean]", o.getClass().getName()));
    }

    public static char toChar(byte b) {
        return (char)b;
    }

    public static char toChar(short b) {
        return (char)b;
    }

    public static char toChar(int b) {
        return (char)b;
    }

    public static char toChar(long b) {
        return (char)b;
    }

    public static char toChar(float b) {
        return (char)b;
    }

    public static char toChar(double b) {
        return (char)b;
    }

    public static char toChar(boolean b) {
        return (char)(b ? 1 : 0);
    }

    public static char toChar(Character b) {
        return b.charValue();
    }

    public static char toChar(String b) {
        return b.charAt(0);
    }

    public static char toChar(Object o) {
        Valid.notNull(o);
        if (o instanceof Byte) {
            return (char)((Byte)o).byteValue();
        }
        if (o instanceof Short) {
            return (char)((Short)o).shortValue();
        }
        if (o instanceof Integer) {
            return (char)((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return (char)((Long)o).longValue();
        }
        if (o instanceof Float) {
            return (char)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (char)((Double)o).doubleValue();
        }
        if (o instanceof Boolean) {
            return (char)((Boolean)o != false ? 1 : 0);
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof String) {
            return ((String)o).charAt(0);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [char]", o.getClass().getName()));
    }

    public static byte[] toBytes(int i) {
        byte[] bt = new byte[]{(byte)(0xFF & i), (byte)((0xFF00 & i) >> 8), (byte)((0xFF0000 & i) >> 16), (byte)((0xFF000000 & i) >> 24)};
        return bt;
    }

    public static byte[] toBytes(short b) {
        int temp = b;
        byte[] bs = new byte[2];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)(temp & 0xFF);
            temp >>= 8;
        }
        return bs;
    }

    public static byte[] toBytes(long n) {
        long temp = n;
        byte[] b = new byte[8];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(temp & 0xFFL);
            temp >>= 8;
        }
        return b;
    }

    public static byte[] toBytes(Byte[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Byte[] toBytes(byte[] bs) {
        Byte[] nbs = new Byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static byte[] toBytes(Short[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(short[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Integer[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(int[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Long[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(long[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Float[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(float[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Double[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(double[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Boolean[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(boolean[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Character[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(char[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(String bs) {
        return Strings.bytes(bs);
    }

    public static byte[] toBytes(String[] bs) {
        byte[] nbs = new byte[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toByte(bs[i]);
        }
        return nbs;
    }

    public static byte[] toBytes(Object o) {
        Valid.notNull(o);
        if (o instanceof Short) {
            return Converts.toBytes((Short)o);
        }
        if (o instanceof Integer) {
            return Converts.toBytes((Integer)o);
        }
        if (o instanceof Long) {
            return Converts.toBytes((Long)o);
        }
        if (o instanceof String) {
            return Converts.toBytes((String)o);
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof Byte[]) {
            return Converts.toBytes((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toBytes((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toBytes((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toBytes((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toBytes((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toBytes((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toBytes((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toBytes((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toBytes((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toBytes((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toBytes((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toBytes((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toBytes((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toBytes((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toBytes((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toBytes((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [byte[]]", o.getClass().getName()));
    }

    public static short[] toShorts(Byte[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(byte[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Short[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Short[] toShorts(short[] bs) {
        Short[] nbs = new Short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static short[] toShorts(Integer[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(int[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Long[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(long[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Float[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(float[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Double[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(double[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Boolean[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(boolean[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Character[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(char[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(String[] bs) {
        short[] nbs = new short[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toShort(bs[i]);
        }
        return nbs;
    }

    public static short[] toShorts(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toShorts((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toShorts((Byte[])o);
        }
        if (o instanceof short[]) {
            return (short[])o;
        }
        if (o instanceof Short[]) {
            return Converts.toShorts((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toShorts((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toShorts((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toShorts((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toShorts((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toShorts((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toShorts((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toShorts((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toShorts((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toShorts((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toShorts((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toShorts((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toShorts((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toShorts((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [short[]]", o.getClass().getName()));
    }

    public static int[] toInts(Byte[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(byte[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Short[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(short[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Integer[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Integer[] toInts(int[] bs) {
        Integer[] nbs = new Integer[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static int[] toInts(Long[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(long[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Float[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(float[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Double[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(double[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Boolean[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(boolean[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Character[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(char[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(String[] bs) {
        int[] nbs = new int[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toInt(bs[i]);
        }
        return nbs;
    }

    public static int[] toInts(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toInts((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toInts((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toInts((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toInts((Short[])o);
        }
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof Integer[]) {
            return Converts.toInts((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toInts((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toInts((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toInts((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toInts((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toInts((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toInts((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toInts((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toInts((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toInts((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toInts((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toInts((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [int[]]", o.getClass().getName()));
    }

    public static long[] toLongs(Byte[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(byte[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Short[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(short[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Integer[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(int[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Long[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Long[] toLongs(long[] bs) {
        Long[] nbs = new Long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static long[] toLongs(Float[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(float[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Double[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(double[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Boolean[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(boolean[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Character[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(char[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(String[] bs) {
        long[] nbs = new long[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toLong(bs[i]);
        }
        return nbs;
    }

    public static long[] toLongs(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toLongs((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toLongs((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toLongs((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toLongs((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toLongs((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toLongs((Integer[])o);
        }
        if (o instanceof long[]) {
            return (long[])o;
        }
        if (o instanceof Long[]) {
            return Converts.toLongs((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toLongs((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toLongs((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toLongs((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toLongs((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toLongs((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toLongs((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toLongs((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toLongs((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toLongs((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [long[]]", o.getClass().getName()));
    }

    public static float[] toFloats(Byte[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(byte[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Short[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(short[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Integer[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(int[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Long[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(long[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Float[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i].floatValue();
        }
        return nbs;
    }

    public static Float[] toFloats(float[] bs) {
        Float[] nbs = new Float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Float.valueOf(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Double[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(double[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Boolean[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(boolean[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Character[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(char[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(String[] bs) {
        float[] nbs = new float[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toFloat(bs[i]);
        }
        return nbs;
    }

    public static float[] toFloats(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toFloats((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toFloats((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toFloats((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toFloats((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toFloats((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toFloats((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toFloats((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toFloats((Long[])o);
        }
        if (o instanceof float[]) {
            return (float[])o;
        }
        if (o instanceof Float[]) {
            return Converts.toFloats((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toFloats((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toFloats((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toFloats((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toFloats((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toFloats((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toFloats((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toFloats((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [float[]]", o.getClass().getName()));
    }

    public static double[] toDoubles(Byte[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(byte[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Short[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(short[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Integer[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(int[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Long[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(long[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Float[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(float[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Double[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Double[] toDoubles(double[] bs) {
        Double[] nbs = new Double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static double[] toDoubles(Boolean[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(boolean[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Character[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(char[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(String[] bs) {
        double[] nbs = new double[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toDouble(bs[i]);
        }
        return nbs;
    }

    public static double[] toDoubles(Object o) {
        Valid.notNull(o);
        if (o instanceof byte[]) {
            return Converts.toDoubles((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toDoubles((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toDoubles((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toDoubles((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toDoubles((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toDoubles((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toDoubles((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toDoubles((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toDoubles((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toDoubles((Float[])o);
        }
        if (o instanceof double[]) {
            return (double[])o;
        }
        if (o instanceof Double[]) {
            return Converts.toDoubles((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toDoubles((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toDoubles((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toDoubles((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toDoubles((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toDoubles((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [double[]]", o.getClass().getName()));
    }

    public static boolean[] toBooleans(Byte[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(byte[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Short[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(short[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Integer[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(int[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Long[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(long[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Float[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(float[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Double[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(double[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Boolean[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static Boolean[] toBooleans(boolean[] bs) {
        Boolean[] nbs = new Boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i];
        }
        return nbs;
    }

    public static boolean[] toBooleans(Character[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(char[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(String[] bs) {
        boolean[] nbs = new boolean[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toBoolean(bs[i]);
        }
        return nbs;
    }

    public static boolean[] toBooleans(Object o) {
        if (o == null) {
            return new boolean[]{false};
        }
        if (o instanceof byte[]) {
            return Converts.toBooleans((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toBooleans((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toBooleans((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toBooleans((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toBooleans((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toBooleans((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toBooleans((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toBooleans((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toBooleans((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toBooleans((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toBooleans((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toBooleans((Double[])o);
        }
        if (o instanceof boolean[]) {
            return (boolean[])o;
        }
        if (o instanceof Boolean[]) {
            return Converts.toBooleans((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toBooleans((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toBooleans((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toBooleans((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [boolean[]]", o.getClass().getName()));
    }

    public static char[] toChars(Byte[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(byte[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Short[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(short[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Integer[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(int[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Long[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(long[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Float[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(float[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Double[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(double[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Boolean[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(boolean[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Converts.toChar(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(Character[] bs) {
        char[] nbs = new char[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i].charValue();
        }
        return nbs;
    }

    public static Character[] toChars(char[] bs) {
        Character[] nbs = new Character[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = Character.valueOf(bs[i]);
        }
        return nbs;
    }

    public static char[] toChars(String bs) {
        return bs.toCharArray();
    }

    public static char[] toChars(String[] bs) {
        int max = 0;
        int offset = 0;
        for (String b : bs) {
            max += b.length();
        }
        char[] chars = new char[max];
        for (String b : bs) {
            char[] c = b.toCharArray();
            System.arraycopy(c, 0, chars, offset, c.length);
            offset += c.length;
        }
        return chars;
    }

    public static char[] toChars(Object o) {
        Valid.notNull(o);
        if (o instanceof String) {
            return Converts.toChars((String)o);
        }
        if (o instanceof byte[]) {
            return Converts.toChars((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toChars((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toChars((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toChars((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toChars((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toChars((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toChars((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toChars((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toChars((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toChars((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toChars((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toChars((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toChars((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toChars((Boolean[])o);
        }
        if (o instanceof char[]) {
            return (char[])o;
        }
        if (o instanceof Character[]) {
            return Converts.toChars((Character[])o);
        }
        if (o instanceof String[]) {
            return Converts.toChars((String[])o);
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [char[]]", o.getClass().getName()));
    }

    public static String[] toStrings(Byte[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(byte[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Short[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(short[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Integer[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(int[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Long[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(long[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Float[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(float[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Double[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(double[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Boolean[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(boolean[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Character[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] == null ? "" : bs[i].toString();
        }
        return nbs;
    }

    public static String[] toStrings(char[] bs) {
        String[] nbs = new String[bs.length];
        int bsLen = bs.length;
        for (int i = 0; i < bsLen; ++i) {
            nbs[i] = bs[i] + "";
        }
        return nbs;
    }

    public static String[] toStrings(Object o) {
        Valid.notNull(o);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof byte[]) {
            return Converts.toStrings((byte[])o);
        }
        if (o instanceof Byte[]) {
            return Converts.toStrings((Byte[])o);
        }
        if (o instanceof short[]) {
            return Converts.toStrings((short[])o);
        }
        if (o instanceof Short[]) {
            return Converts.toStrings((Short[])o);
        }
        if (o instanceof int[]) {
            return Converts.toStrings((int[])o);
        }
        if (o instanceof Integer[]) {
            return Converts.toStrings((Integer[])o);
        }
        if (o instanceof long[]) {
            return Converts.toStrings((long[])o);
        }
        if (o instanceof Long[]) {
            return Converts.toStrings((Long[])o);
        }
        if (o instanceof float[]) {
            return Converts.toStrings((float[])o);
        }
        if (o instanceof Float[]) {
            return Converts.toStrings((Float[])o);
        }
        if (o instanceof double[]) {
            return Converts.toStrings((double[])o);
        }
        if (o instanceof Double[]) {
            return Converts.toStrings((Double[])o);
        }
        if (o instanceof boolean[]) {
            return Converts.toStrings((boolean[])o);
        }
        if (o instanceof Boolean[]) {
            return Converts.toStrings((Boolean[])o);
        }
        if (o instanceof char[]) {
            return Converts.toStrings((char[])o);
        }
        if (o instanceof Character[]) {
            return Converts.toStrings((Character[])o);
        }
        if (o instanceof String[]) {
            return (String[])o;
        }
        throw Exceptions.convert(Strings.format("unable to convert [{}] to [String[]]", o.getClass().getName()));
    }
}

