/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.codec.Base64s;

public class RC4 {
    private static final int BOX_LENGTH = 256;
    private static final int KEY_MIN_LENGTH = 5;
    private int[] box;

    public RC4(String key) {
        this(Strings.bytes(key));
    }

    public RC4(byte[] key) {
        this.initKey(key);
    }

    public String encrypt(String s) {
        return Base64s.encodeToString(this.encryptOrDecrypt(Strings.bytes(s)));
    }

    public byte[] encrypt(byte[] bs) {
        return this.encryptOrDecrypt(bs);
    }

    public String decrypt(String s) {
        return new String(this.encryptOrDecrypt(Base64s.decodeToBytes(s)));
    }

    public byte[] decrypt(byte[] bs) {
        return this.encryptOrDecrypt(bs);
    }

    public byte[] encryptOrDecrypt(byte[] bs) {
        int[] box = (int[])this.box.clone();
        byte[] code = new byte[bs.length];
        int i = 0;
        int j = 0;
        for (int n = 0; n < bs.length; ++n) {
            i = (i + 1) % 256;
            j = (j + box[i]) % 256;
            Arrays1.swap(box, i, j);
            int rand = box[(box[i] + box[j]) % 256];
            code[n] = (byte)(rand ^ bs[n]);
        }
        return code;
    }

    public void initKey(String key) {
        this.initKey(Strings.bytes(key));
    }

    public void initKey(byte[] key) {
        int length = key.length;
        if (length < 5 || length >= 256) {
            throw Exceptions.init(Strings.format("key length has to be between {} and {}", 5, 255));
        }
        this.box = RC4.initBox(key);
    }

    private static int[] initBox(byte[] key) {
        int i;
        int[] box = new int[256];
        int j = 0;
        for (i = 0; i < 256; ++i) {
            box[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            j = (j + box[i] + key[i % key.length] & 0xFF) % 256;
            Arrays1.swap(box, i, j);
        }
        return box;
    }
}

