/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ext.dom;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.ext.dom.DomParserParam;
import cn.orionsec.kit.lang.utils.ext.dom.DomSupport;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

class DomParser {
    private final Element element;
    private final String formula;
    private final List<DomParserParam> domParserParams;

    DomParser(Element element, String formula) {
        this.element = element;
        this.formula = formula;
        this.domParserParams = new ArrayList<DomParserParam>();
        this.toParams();
    }

    private void toParams() {
        try {
            String[] params;
            for (String param : params = this.formula.split(">")) {
                DomParserParam domParserParam = new DomParserParam();
                param = param.trim();
                int is = param.indexOf("[");
                int ie = param.indexOf("]");
                int ak = param.indexOf(":");
                int av = param.indexOf("=");
                if (is != -1 && ie != -1 && ak != -1 && av != -1) {
                    domParserParam.setName(param.substring(0, is));
                    domParserParam.setIndex(Integer.parseInt(param.substring(is + 1, ie)));
                    domParserParam.setKey(param.substring(ak + 1, av));
                    domParserParam.setValue(param.substring(av + 1));
                } else if (is != -1 && ie != -1) {
                    domParserParam.setName(param.substring(0, is));
                    domParserParam.setIndex(Integer.parseInt(param.substring(is + 1, ie)));
                } else if (ak != -1 && av != -1) {
                    domParserParam.setName(param.substring(0, ak));
                    domParserParam.setKey(param.substring(ak + 1, av));
                    domParserParam.setValue(param.substring(av + 1));
                } else {
                    domParserParam.setName(param);
                }
                this.domParserParams.add(domParserParam);
            }
        }
        catch (Exception e) {
            throw Exceptions.parse("cannot parse formula " + this.formula, (Throwable)e);
        }
    }

    String getElementValue() {
        return this.getElement().getText();
    }

    Element getElement() {
        Element now = this.element;
        for (DomParserParam domParserParam : this.domParserParams) {
            Element element;
            List elements;
            if (domParserParam.getIndex() != 0 && domParserParam.getKey() != null) {
                elements = now.elements(domParserParam.getName());
                if (elements == null || elements.size() < domParserParam.getIndex() + 1) {
                    throw Exceptions.noSuchElement(Strings.format("not found element {}, index: {}, attr: {}, attrValue: {}", domParserParam.getName(), domParserParam.getIndex(), domParserParam.getKey(), domParserParam.getValue()));
                }
                Element element2 = (Element)elements.get(domParserParam.getIndex());
                String attribute = DomSupport.getAttribute(element2, domParserParam.getKey());
                if (attribute != null && attribute.equals(domParserParam.getValue())) {
                    now = element2;
                    continue;
                }
                throw Exceptions.noSuchElement(Strings.format("not found element {}, index: {}, attr: {}, attrValue: {}", domParserParam.getName(), domParserParam.getIndex(), domParserParam.getKey(), domParserParam.getValue()));
            }
            if (domParserParam.getIndex() != 0) {
                elements = now.elements(domParserParam.getName());
                if (elements == null || elements.size() < domParserParam.getIndex() + 1) {
                    throw Exceptions.noSuchElement(Strings.format("not found element {}, index: {}", domParserParam.getName(), domParserParam.getIndex()));
                }
                now = (Element)elements.get(domParserParam.getIndex());
                continue;
            }
            if (domParserParam.getKey() != null) {
                element = now.element(domParserParam.getName());
                if (element == null) {
                    throw Exceptions.noSuchElement(Strings.format("not found element {}", domParserParam.getName()));
                }
                String attribute = DomSupport.getAttribute(element, domParserParam.getKey());
                if (attribute != null && attribute.equals(domParserParam.getValue())) {
                    now = element;
                    continue;
                }
                throw Exceptions.noSuchElement(Strings.format("not found element {}, attr: {}, attrValue: {}", domParserParam.getName(), domParserParam.getKey(), domParserParam.getValue()));
            }
            element = now.element(domParserParam.getName());
            if (element == null) {
                throw Exceptions.noSuchElement(Strings.format("not found element {}", domParserParam.getName()));
            }
            now = element;
        }
        return now;
    }
}

