/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ext.dom;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.ext.dom.DomBeanWrapper;
import cn.orionsec.kit.lang.utils.ext.dom.DomNode;
import cn.orionsec.kit.lang.utils.ext.dom.DomParser;
import cn.orionsec.kit.lang.utils.io.Files1;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultCDATA;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;

public class DomSupport {
    private static final Map<String, String> ESCAPE_MAP = new HashMap<String, String>();
    private static final Map<String, String> UNESCAPE_MAP = new HashMap<String, String>();
    private static final String DEFAULT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    private DomSupport() {
    }

    public static boolean isEscape(String s) {
        return s.chars().anyMatch(i -> Objects.nonNull(ESCAPE_MAP.get((char)i + "")));
    }

    public static String escape(String s) {
        for (Map.Entry<String, String> e : ESCAPE_MAP.entrySet()) {
            s = s.replaceAll(e.getKey(), e.getValue());
        }
        return s;
    }

    public static String unescape(String s) {
        for (Map.Entry<String, String> e : UNESCAPE_MAP.entrySet()) {
            s = s.replaceAll(e.getKey(), e.getValue());
        }
        return s;
    }

    public static Element parse(Element element, String formula) {
        return new DomParser(element, formula).getElement();
    }

    public static String parseValue(Element element, String formula) {
        return new DomParser(element, formula).getElementValue();
    }

    public static Map<String, List<Element>> getElements(Element element) {
        LinkedHashMap<String, List<Element>> map = new LinkedHashMap<String, List<Element>>();
        List elements = element.elements();
        for (Element e : elements) {
            String name = e.getName();
            List els = map.computeIfAbsent(name, k -> new ArrayList());
            els.add(e);
        }
        return map;
    }

    public static Map<String, String> getAttributes(Element e) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List attributes = e.attributes();
        for (Attribute attr : attributes) {
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    public static String getAttribute(Element e, String key) {
        List attributes = e.attributes();
        for (Attribute attr : attributes) {
            if (!key.trim().equals(attr.getName().trim())) continue;
            return attr.getValue();
        }
        return null;
    }

    public static Document toDocument(String xml) {
        try {
            return new SAXReader().read((Reader)new StringReader(xml));
        }
        catch (Exception e) {
            throw Exceptions.argument("xml parse to document error " + e.getMessage(), e);
        }
    }

    public static Document toDocument(String rootName, Map<String, ?> childMap) {
        DefaultDocument d = new DefaultDocument();
        d.setRootElement(DomSupport.toElement(rootName, childMap, true));
        return d;
    }

    public static Document toDocument(String rootName, Map<String, ?> childMap, boolean cdata) {
        DefaultDocument d = new DefaultDocument();
        DefaultElement root = new DefaultElement(rootName);
        DomSupport.toElement((Element)root, childMap, cdata);
        d.setRootElement((Element)root);
        return d;
    }

    public static Element toElement(String xml) {
        return DomSupport.toDocument(xml).getRootElement();
    }

    public static Element toElement(String rootName, Map<String, ?> childMap) {
        return DomSupport.toElement(rootName, childMap, true);
    }

    public static Element toElement(String rootName, Map<String, ?> childMap, boolean cdata) {
        DefaultElement root = new DefaultElement(rootName);
        DomSupport.toElement((Element)root, childMap, cdata);
        return root;
    }

    private static void toElement(Element element, Map<String, ?> childMap, boolean cdata) {
        for (Map.Entry<String, ?> entry : childMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            DefaultElement child = new DefaultElement(entry.getKey());
            if (value instanceof Map) {
                DomSupport.toElement((Element)child, (Map)value, cdata);
                element.add((Element)child);
                continue;
            }
            if (value instanceof List) {
                DomSupport.toElementList(element, entry.getKey(), (List)value, cdata);
                continue;
            }
            if (cdata) {
                child.add((CDATA)new DefaultCDATA(value.toString()));
            } else {
                child.setText(value.toString());
            }
            element.add((Element)child);
        }
    }

    private static void toElementList(Element element, String key, List<?> list, boolean cdata) {
        if (Lists.isEmpty(list)) {
            return;
        }
        DefaultElement child = new DefaultElement(key);
        int i = 0;
        for (Object obj : list) {
            if (i++ > 0) {
                child = new DefaultElement(key);
            }
            if (obj == null) continue;
            if (obj instanceof Map) {
                DomSupport.toElement((Element)child, (Map)obj, cdata);
                element.add((Element)child);
                continue;
            }
            if (obj instanceof List) {
                HashMap listMap = new HashMap();
                listMap.put(key, obj);
                DomSupport.toElement((Element)child, listMap, cdata);
                element.add((Element)child);
                continue;
            }
            if (cdata) {
                child.add((CDATA)new DefaultCDATA(obj.toString()));
            } else {
                child.setText(obj.toString());
            }
            element.add((Element)child);
        }
    }

    public static String formatIndent(String xml) {
        return DomSupport.formatIndent(xml, "    ", true);
    }

    public static String formatIndent(String xml, boolean newLine) {
        return DomSupport.formatIndent(xml, "    ", newLine);
    }

    public static String formatIndent(String xml, String indent) {
        return DomSupport.formatIndent(xml, indent, true);
    }

    public static String formatIndent(String xml, String indent, boolean newLine) {
        return DomSupport.format(xml, new OutputFormat(indent, newLine));
    }

    public static String formatExpandTag(String xml) {
        return DomSupport.formatExpandTag(DomSupport.toDocument(xml));
    }

    public static String formatExpandTag(Document document) {
        OutputFormat format = new OutputFormat();
        format.setExpandEmptyElements(true);
        return DomSupport.format(document, format);
    }

    public static String format(String xml) {
        return DomSupport.format(DomSupport.toDocument(xml));
    }

    public static String format(Document document) {
        OutputFormat format = new OutputFormat("    ", true);
        format.setExpandEmptyElements(true);
        return DomSupport.format(document, format);
    }

    public static String format(String xml, OutputFormat format) {
        return DomSupport.format(DomSupport.toDocument(xml), format);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String format(Document document, OutputFormat format) {
        try (XMLWriter writer = null;){
            try (StringWriter stringWriter = new StringWriter();){
                writer = new XMLWriter((Writer)stringWriter, format);
                writer.write(document);
                writer.flush();
                String string = stringWriter.getBuffer().toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void cleanComment(Document document) {
        DomSupport.cleanComment(document.getRootElement());
    }

    public static void cleanComment(Element element) {
        Iterator nodes = element.nodeIterator();
        ArrayList<Object> rmNodes = new ArrayList<Object>();
        while (nodes.hasNext()) {
            Node subNode = (Node)nodes.next();
            if (subNode.getNodeType() != 8) continue;
            rmNodes.add(subNode);
            rmNodes.add(nodes.next());
        }
        for (Node node : rmNodes) {
            element.remove(node);
        }
        Iterator eleIt = element.elementIterator();
        while (eleIt.hasNext()) {
            DomSupport.cleanComment((Element)eleIt.next());
        }
    }

    public static <T> T toBean(String xml, Class<T> clazz) {
        return DomSupport.toBean(xml, clazz, null);
    }

    public static <T> T toBean(String xml, String formula, Class<T> clazz) {
        return DomSupport.toBean(xml, formula, clazz, null);
    }

    public static <T> T toBean(String xml, Class<T> clazz, Map<String, Object> convertMapper) {
        return DomBeanWrapper.toBean(DomSupport.toElement(xml), clazz, convertMapper);
    }

    public static <T> T toBean(String xml, String formula, Class<T> clazz, Map<String, Object> convertMapper) {
        Element match = new DomParser(DomSupport.toElement(xml), formula).getElement();
        return DomBeanWrapper.toBean(match, clazz, convertMapper);
    }

    public static <T> T toBean(Document document, Class<T> clazz) {
        return DomSupport.toBean(document, clazz, null);
    }

    public static <T> T toBean(Document document, String formula, Class<T> clazz) {
        return DomSupport.toBean(document, formula, clazz, null);
    }

    public static <T> T toBean(Document document, Class<T> clazz, Map<String, Object> convertMapper) {
        return DomBeanWrapper.toBean(document.getRootElement(), clazz, convertMapper);
    }

    public static <T> T toBean(Document document, String formula, Class<T> clazz, Map<String, Object> convertMapper) {
        Element root = document.getRootElement();
        Element match = new DomParser(root, formula).getElement();
        return DomBeanWrapper.toBean(match, clazz, convertMapper);
    }

    public static <T> T toBean(Element element, Class<T> clazz) {
        return DomSupport.toBean(element, clazz, null);
    }

    public static <T> T toBean(Element element, String formula, Class<T> clazz) {
        return DomSupport.toBean(element, formula, clazz, null);
    }

    public static <T> T toBean(Element element, Class<T> clazz, Map<String, Object> convertMapper) {
        return DomBeanWrapper.toBean(element, clazz, convertMapper);
    }

    public static <T> T toBean(Element element, String formula, Class<T> clazz, Map<String, Object> convertMapper) {
        Element match = new DomParser(element, formula).getElement();
        return DomBeanWrapper.toBean(match, clazz, convertMapper);
    }

    public static Map<String, Object> toMap(String xml) {
        return DomSupport.toMap(xml, (Class)null);
    }

    public static Map<String, Object> toMap(String xml, String formula) {
        return DomSupport.toMap(xml, formula, null);
    }

    public static Map<String, Object> toMap(String xml, Class<?> mapClass) {
        return DomBeanWrapper.toMap(DomSupport.toElement(xml), mapClass);
    }

    public static Map<String, Object> toMap(String xml, String formula, Class<?> mapClass) {
        Element match = new DomParser(DomSupport.toElement(xml), formula).getElement();
        return DomBeanWrapper.toMap(match, mapClass);
    }

    public static Map<String, Object> toMap(Document document) {
        return DomSupport.toMap(document, (Class)null);
    }

    public static Map<String, Object> toMap(Document document, String formula) {
        return DomSupport.toMap(document, formula, null);
    }

    public static Map<String, Object> toMap(Document document, Class<?> mapClass) {
        return DomBeanWrapper.toMap(document.getRootElement(), mapClass);
    }

    public static Map<String, Object> toMap(Document document, String formula, Class<?> mapClass) {
        Element root = document.getRootElement();
        Element match = new DomParser(root, formula).getElement();
        return DomBeanWrapper.toMap(match, mapClass);
    }

    public static Map<String, Object> toMap(Element element) {
        return DomSupport.toMap(element, (Class)null);
    }

    public static Map<String, Object> toMap(Element element, String formula) {
        return DomSupport.toMap(element, formula, null);
    }

    public static Map<String, Object> toMap(Element element, Class<?> mapClass) {
        return DomBeanWrapper.toMap(element, mapClass);
    }

    public static Map<String, Object> toMap(Element element, String formula, Class<?> mapClass) {
        Element match = new DomParser(element, formula).getElement();
        return DomBeanWrapper.toMap(match, mapClass);
    }

    public static Map<String, DomNode> toDomNode(String xml) {
        return DomBeanWrapper.toDomNode(DomSupport.toElement(xml));
    }

    public static Map<String, DomNode> toDomNode(String xml, String formula) {
        Element match = new DomParser(DomSupport.toElement(xml), formula).getElement();
        return DomBeanWrapper.toDomNode(match);
    }

    public static Map<String, DomNode> toDomNode(Document document) {
        return DomBeanWrapper.toDomNode(document.getRootElement());
    }

    public static Map<String, DomNode> toDomNode(Document document, String formula) {
        return DomSupport.toDomNode(document.getRootElement(), formula);
    }

    public static Map<String, DomNode> toDomNode(Element element) {
        return DomBeanWrapper.toDomNode(element);
    }

    public static Map<String, DomNode> toDomNode(Element element, String formula) {
        Element match = new DomParser(element, formula).getElement();
        return DomBeanWrapper.toDomNode(match);
    }

    public static String asXml(Document document) {
        return DomSupport.format(document);
    }

    public static String asXml(Element element) {
        return DomSupport.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + element.asXML());
    }

    public static void write(String xml, File file) throws IOException {
        Files1.touch(file);
        try (FileOutputStream out = Files1.openOutputStream(file);){
            out.write(Strings.bytes(DomSupport.format(xml)));
        }
    }

    public static void write(Document document, File file) throws IOException {
        Files1.touch(file);
        try (FileOutputStream out = Files1.openOutputStream(file);){
            out.write(Strings.bytes(DomSupport.format(document)));
        }
    }

    public static void write(Element element, File file) throws IOException {
        Files1.touch(file);
        try (FileOutputStream out = Files1.openOutputStream(file);){
            out.write(Strings.bytes(DomSupport.format(DomSupport.asXml(element))));
        }
    }

    static {
        ESCAPE_MAP.put("&", "&amp;");
        ESCAPE_MAP.put(">", "&gt;");
        ESCAPE_MAP.put("<", "&lt;");
        ESCAPE_MAP.put("\"", "&quot;");
        ESCAPE_MAP.put("'", "&apos;");
        UNESCAPE_MAP.put("&amp;", "&");
        UNESCAPE_MAP.put("&gt;", ">");
        UNESCAPE_MAP.put("&lt;", "<");
        UNESCAPE_MAP.put("&quot;", "\"");
        UNESCAPE_MAP.put("&apos;", "'");
    }
}

