/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ext.yml;

import cn.orionsec.kit.lang.define.collect.MutableHashSet;
import cn.orionsec.kit.lang.define.collect.MutableLinkedHashMap;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.io.Files1;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.yaml.snakeyaml.Yaml;

public class YmlExt {
    private final Yaml yaml;
    private final MutableLinkedHashMap<String, Object> store;

    public YmlExt(String yml) {
        this.yaml = new Yaml();
        this.store = (MutableLinkedHashMap)this.yaml.loadAs(yml, MutableLinkedHashMap.class);
    }

    public YmlExt(File file) {
        try (FileInputStream in = Files1.openInputStream(file);){
            this.yaml = new Yaml();
            this.store = (MutableLinkedHashMap)this.yaml.loadAs((InputStream)in, MutableLinkedHashMap.class);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public YmlExt(InputStream in) {
        this.yaml = new Yaml();
        this.store = (MutableLinkedHashMap)this.yaml.loadAs(in, MutableLinkedHashMap.class);
    }

    public static YmlExt load(String yml) {
        return new YmlExt(yml);
    }

    public static YmlExt load(File file) {
        return new YmlExt(file);
    }

    public static YmlExt load(InputStream in) {
        return new YmlExt(in);
    }

    public MutableHashSet<String> getKeys() {
        return new MutableHashSet<String>(this.store.keySet());
    }

    public MutableLinkedHashMap<String, Object> getValues() {
        return this.store;
    }

    public Map<String, Object> getValues(String key) {
        try {
            Map value = null;
            String[] nodes = key.split("\\.");
            int len = nodes.length;
            for (int i = 0; i < len; ++i) {
                value = i == 0 ? (Map)this.store.getObject(nodes[0]) : (Map)value.get(nodes[i]);
            }
            return value;
        }
        catch (Exception e) {
            throw Exceptions.argument("invalid key " + key);
        }
    }

    public Set<String> getKeys(String key) {
        try {
            Map map = null;
            String[] nodes = key.split("\\.");
            int len = nodes.length;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    map = (Map)this.store.getObject(nodes[0]);
                } else if (len - 1 > i) {
                    map = (Map)map.get(nodes[i]);
                }
                if (len - 1 != i) continue;
                if (i == 0) {
                    return map.keySet();
                }
                Object last = map.get(nodes[i]);
                if (last instanceof Map) {
                    return ((Map)last).keySet();
                }
                return new HashSet<String>();
            }
            return null;
        }
        catch (Exception e) {
            throw Exceptions.argument("invalid key " + key);
        }
    }

    public String getValue(String key) {
        try {
            String value = null;
            Map map = null;
            String[] nodes = key.split("\\.");
            int len = nodes.length;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    if (len == 1) {
                        value = this.store.getObject(nodes[0]).toString();
                        continue;
                    }
                    map = (Map)this.store.getObject(nodes[0]);
                    continue;
                }
                if (len - 1 > i) {
                    map = (Map)map.get(nodes[i]);
                    continue;
                }
                if (len - 1 != i) continue;
                value = map.get(nodes[i]).toString();
            }
            return value;
        }
        catch (Exception e) {
            throw Exceptions.argument("invalid key " + key);
        }
    }

    public Yaml getYaml() {
        return this.yaml;
    }

    public MutableLinkedHashMap<String, Object> getMap() {
        return this.store;
    }

    public void forEach(BiConsumer<Object, Object> action) {
        this.store.forEach(action);
    }
}

