/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.tar;

import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileCompressor;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarCompressor
extends BaseFileCompressor {
    private TarArchiveOutputStream outputStream;

    public TarCompressor() {
        this("tar");
    }

    public TarCompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCompress() throws Exception {
        try {
            ArchiveEntry entity;
            this.outputStream = new TarArchiveOutputStream(Files1.openOutputStreamFast(new File(this.getAbsoluteCompressPath())));
            for (Map.Entry fileEntity : this.compressFiles.entrySet()) {
                entity = this.outputStream.createArchiveEntry((File)fileEntity.getValue(), (String)fileEntity.getKey());
                this.outputStream.putArchiveEntry(entity);
                try (InputStream in = Files1.openInputStreamFast((File)fileEntity.getValue());){
                    Streams.transfer(in, (OutputStream)this.outputStream);
                }
                this.outputStream.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            for (Map.Entry fileEntity : this.compressStreams.entrySet()) {
                entity = new TarArchiveEntry((String)fileEntity.getKey());
                entity.setSize((long)((InputStream)fileEntity.getValue()).available());
                this.outputStream.putArchiveEntry(entity);
                Streams.transfer((InputStream)fileEntity.getValue(), (OutputStream)this.outputStream);
                this.outputStream.closeArchiveEntry();
                super.notify((String)fileEntity.getKey());
            }
            this.outputStream.finish();
        }
        finally {
            Streams.close((AutoCloseable)this.outputStream);
        }
    }

    public TarArchiveOutputStream getCloseable() {
        return this.outputStream;
    }
}

