/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.math;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Compares;
import cn.orionsec.kit.lang.utils.Objects1;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigIntegers {
    private BigIntegers() {
    }

    public static BigInteger toBigInteger(Object o) {
        return BigIntegers.objectToBigInteger(o);
    }

    public static BigInteger toBigInteger(Object o, BigInteger defaultV) {
        return Objects1.def(BigIntegers.objectToBigInteger(o), defaultV);
    }

    public static BigInteger[] toBigIntegers(Object ... o) {
        if (Arrays1.length(o) == 0) {
            return new BigInteger[0];
        }
        BigInteger[] r = new BigInteger[o.length];
        int len = o.length;
        for (int i = 0; i < len; ++i) {
            r[i] = BigIntegers.objectToBigInteger(o[i]);
        }
        return r;
    }

    private static BigInteger objectToBigInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof BigDecimal) {
            return BigInteger.valueOf(((BigDecimal)o).longValue());
        }
        if (o instanceof String) {
            return new BigInteger((String)o);
        }
        if (o instanceof Boolean) {
            if (((Boolean)o).booleanValue()) {
                return BigInteger.ONE;
            }
            return BigInteger.ZERO;
        }
        if (o instanceof Long) {
            return BigInteger.valueOf((Long)o);
        }
        return new BigInteger(o.toString());
    }

    public static String toStr(BigInteger b) {
        return BigIntegers.toStr(b, null, 10);
    }

    public static String toStr(BigInteger b, String defaultV) {
        return BigIntegers.toStr(b, defaultV, 10);
    }

    public static String toStr(BigInteger b, String defaultV, int radix) {
        if (b == null) {
            return defaultV;
        }
        return b.toString(radix);
    }

    public static Long toLong(BigInteger b) {
        return BigIntegers.toLong(b, 0L);
    }

    public static Long toLong(BigInteger b, Long defaultV) {
        if (b == null) {
            return defaultV;
        }
        return b.longValue();
    }

    public static Integer toInteger(BigInteger b) {
        return BigIntegers.toInteger(b, 0);
    }

    public static Integer toInteger(BigInteger b, Integer defaultV) {
        if (b == null) {
            return defaultV;
        }
        return b.intValue();
    }

    public static Double toDouble(BigInteger b) {
        return BigIntegers.toDouble(b, 0.0);
    }

    public static Double toDouble(BigInteger b, Double defaultV) {
        if (b == null) {
            return defaultV;
        }
        return b.doubleValue();
    }

    public static BigInteger add(BigInteger s, BigInteger ... b) {
        return BigIntegers.add(false, s, b);
    }

    public static BigInteger addSkipNegative(BigInteger s, BigInteger ... b) {
        return BigIntegers.add(true, s, b);
    }

    private static BigInteger add(boolean skipNegative, BigInteger s, BigInteger ... b) {
        if (s == null) {
            s = BigInteger.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigInteger c : b) {
            if (c == null) continue;
            if (skipNegative) {
                if (c.compareTo(BigInteger.ZERO) <= 0) continue;
                s = s.add(c);
                continue;
            }
            s = s.add(c);
        }
        return s;
    }

    public static BigInteger subtract(BigInteger s, BigInteger ... b) {
        return BigIntegers.subtract(false, s, b);
    }

    public static BigInteger subtractSkipNegative(BigInteger s, BigInteger ... b) {
        return BigIntegers.subtract(true, s, b);
    }

    private static BigInteger subtract(boolean skipNegative, BigInteger s, BigInteger ... b) {
        if (s == null) {
            s = BigInteger.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigInteger c : b) {
            if (c == null) continue;
            if (skipNegative) {
                if (c.compareTo(BigInteger.ZERO) <= 0) continue;
                s = s.subtract(c);
                continue;
            }
            s = s.subtract(c);
        }
        return s;
    }

    public static BigInteger multiply(BigInteger s, BigInteger ... b) {
        return BigIntegers.multiply(false, false, s, b);
    }

    public static BigInteger multiplySkip(BigInteger s, BigInteger ... b) {
        return BigIntegers.multiply(true, true, s, b);
    }

    public static BigInteger multiplySkipNegative(BigInteger s, BigInteger ... b) {
        return BigIntegers.multiply(true, false, s, b);
    }

    public static BigInteger multiplySkipZero(BigInteger s, BigInteger ... b) {
        return BigIntegers.multiply(false, true, s, b);
    }

    private static BigInteger multiply(boolean skipNegative, boolean skipZero, BigInteger s, BigInteger ... b) {
        if (s == null) {
            s = BigInteger.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigInteger c : b) {
            if (c == null) continue;
            if (skipNegative || skipZero) {
                int compare = c.compareTo(BigInteger.ZERO);
                if (compare > 0) {
                    s = s.multiply(c);
                    continue;
                }
                if (compare == 0) {
                    if (skipZero) continue;
                    s = s.multiply(c);
                    continue;
                }
                if (skipNegative) continue;
                s = s.multiply(c);
                continue;
            }
            s = s.multiply(c);
        }
        return s;
    }

    public static BigInteger divide(BigInteger s, BigInteger ... b) {
        return BigIntegers.divide(false, false, s, b);
    }

    public static BigInteger divideSkip(BigInteger s, BigInteger ... b) {
        return BigIntegers.divide(true, true, s, b);
    }

    public static BigInteger divideSkipNegative(BigInteger s, BigInteger ... b) {
        return BigIntegers.divide(true, false, s, b);
    }

    public static BigInteger divideSkipZero(BigInteger s, BigInteger ... b) {
        return BigIntegers.divide(false, true, s, b);
    }

    private static BigInteger divide(boolean skipNegative, boolean skipZero, BigInteger s, BigInteger ... b) {
        if (s == null) {
            return BigInteger.ZERO;
        }
        if (Arrays1.length(b) == 0) {
            return s;
        }
        for (BigInteger c : b) {
            if (c == null) continue;
            if (skipNegative || skipZero) {
                int compare = c.compareTo(BigInteger.ZERO);
                if (compare > 0) {
                    s = s.divide(c);
                    continue;
                }
                if (compare == 0) {
                    if (skipZero) continue;
                    s = s.divide(c);
                    continue;
                }
                if (skipNegative) continue;
                s = s.divide(c);
                continue;
            }
            s = s.divide(c);
        }
        return s;
    }

    public static BigInteger max(BigInteger ... b) {
        int len = Arrays1.length(b);
        if (len == 0) {
            return null;
        }
        BigInteger max = b[0];
        if (max == null) {
            for (int offset = 1; offset < len; ++offset) {
                BigInteger bi = b[offset];
                if (bi == null) continue;
                max = bi;
                ++offset;
                break;
            }
            if (max == null) {
                return null;
            }
        }
        for (int i = offset; i < len; ++i) {
            if (b[i] == null || max.compareTo(b[i]) >= 0) continue;
            max = b[i];
        }
        return max;
    }

    public static BigInteger min(BigInteger ... b) {
        int len = Arrays1.length(b);
        if (len == 0) {
            return null;
        }
        BigInteger min = b[0];
        if (min == null) {
            for (int offset = 1; offset < len; ++offset) {
                BigInteger bi = b[offset];
                if (bi == null) continue;
                min = bi;
                ++offset;
                break;
            }
            if (min == null) {
                return null;
            }
        }
        for (int i = offset; i < len; ++i) {
            if (b[i] == null || min.compareTo(b[i]) <= 0) continue;
            min = b[i];
        }
        return min;
    }

    public static BigInteger sum(BigInteger ... b) {
        return BigIntegers.sum(false, b);
    }

    public static BigInteger sumSkipNegative(BigInteger ... b) {
        return BigIntegers.sum(true, b);
    }

    private static BigInteger sum(boolean skipNegative, BigInteger ... b) {
        BigInteger sum = BigInteger.ZERO;
        int len = Arrays1.length(b);
        for (int i = 0; i < len; ++i) {
            BigInteger d = b[i];
            if (d.compareTo(BigInteger.ZERO) < 0) {
                if (skipNegative) continue;
                sum = sum.add(d);
                continue;
            }
            sum = sum.add(d);
        }
        return sum;
    }

    public static BigInteger avg(BigInteger ... b) {
        return BigIntegers.avg(false, false, b);
    }

    public static BigInteger avgSkipZero(BigInteger ... b) {
        return BigIntegers.avg(true, false, b);
    }

    public static BigInteger avgSkipNegative(BigInteger ... b) {
        return BigIntegers.avg(false, true, b);
    }

    public static BigInteger avgSkip(BigInteger ... b) {
        return BigIntegers.avg(true, true, b);
    }

    private static BigInteger avg(boolean skipZero, boolean skipNegative, BigInteger ... b) {
        int len = Arrays1.length(b);
        int skip = 0;
        if (len == 0) {
            return null;
        }
        if (skipZero && skipNegative) {
            for (BigInteger d : b) {
                if (d.compareTo(BigInteger.ZERO) > 0) continue;
                ++skip;
            }
        } else if (skipZero) {
            for (BigInteger d : b) {
                if (d.compareTo(BigInteger.ZERO) != 0) continue;
                ++skip;
            }
        } else if (skipNegative) {
            for (BigInteger d : b) {
                if (d.compareTo(BigInteger.ZERO) >= 0) continue;
                ++skip;
            }
        }
        BigInteger c = skipNegative ? BigIntegers.add(true, null, b) : BigIntegers.add(false, null, b);
        return c.divide(BigInteger.valueOf(len - skip));
    }

    public static boolean eq(BigInteger d1, BigInteger d2) {
        return Objects1.eq(d1, d2);
    }

    public static boolean compared(BigInteger d1, BigInteger d2) {
        return Compares.compared(d1, d2);
    }

    public static boolean isNegative(BigInteger d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigInteger.ZERO) < 0;
    }

    public static BigInteger abs(BigInteger d) {
        if (d == null) {
            return null;
        }
        return d.abs();
    }

    public static boolean isZero(BigInteger d) {
        if (d == null) {
            return false;
        }
        return BigInteger.ZERO.equals(d);
    }

    public static boolean ltZero(BigInteger d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigInteger.ZERO) < 0;
    }

    public static boolean lteZero(BigInteger d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigInteger.ZERO) <= 0;
    }

    public static boolean gtZero(BigInteger d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean gteZero(BigInteger d) {
        if (d == null) {
            return false;
        }
        return d.compareTo(BigInteger.ZERO) >= 0;
    }
}

