/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.net;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.collect.Lists;
import cn.orionsec.kit.lang.utils.random.Randoms;
import cn.orionsec.kit.lang.utils.regexp.Matches;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IPs {
    public static final String IP;
    private static final int[][] IP_RANGE;

    private IPs() {
    }

    public static String checkIp(String ip) {
        if (Strings.isBlank(ip)) {
            return null;
        }
        if ("unknown".equalsIgnoreCase(ip)) {
            return null;
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            return "127.0.0.1";
        }
        if (!IPs.isIp(ip)) {
            return null;
        }
        return ip;
    }

    public static boolean isLocal(String ip) {
        if (Strings.isBlank(ip)) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(ip.trim())) {
            return true;
        }
        if ("127.0.0.1".equals(ip.trim())) {
            return true;
        }
        if ("0:0:0:0:0:0:0:1".equals(ip.trim())) {
            return true;
        }
        for (String s : IPs.getLocalHosts().keySet()) {
            if (!s.equals(ip.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isIpv4(String ip) {
        try {
            String[] pp = ip.split("\\.");
            if (pp.length != 4) {
                return false;
            }
            for (String p : pp) {
                if (p.length() > 3) {
                    return false;
                }
                int b = Integer.parseInt(p);
                if (b <= 255 && b >= 0 && Integer.toString(b).equals(p)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIpv6(String ip) {
        return Matches.isIpv6(ip);
    }

    public static boolean isIp(String ip) {
        return IPs.isIpv4(ip) || IPs.isIpv6(ip);
    }

    public static boolean isInternalIp(String ip) {
        return IPs.isInternalIp(IPs.ipv4ToBytes(ip)) || "127.0.0.1".equals(ip) || "localhost".equals(ip);
    }

    public static boolean isInternalIp(byte[] addr) {
        if (addr == null || addr.length < 2) {
            return true;
        }
        switch (addr[0]) {
            case 10: {
                return true;
            }
            case -84: {
                if (addr[1] >= 16) {
                    return true;
                }
            }
            case -64: {
                if (addr[1] != -88) break;
                return true;
            }
        }
        return false;
    }

    public static byte[] ipv4ToBytes(String ip) {
        if (ip.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[4];
        String[] elements = ip.split("\\.", -1);
        try {
            switch (elements.length) {
                case 1: {
                    long l = Long.parseLong(elements[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    bytes[0] = (byte)(l >> 24 & 0xFFL);
                    bytes[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(elements[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    bytes[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(elements[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    bytes[1] = (byte)(l >> 16 & 0xFFL);
                    bytes[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(elements[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    bytes[2] = (byte)(l >> 8 & 0xFFL);
                    bytes[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(elements[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        bytes[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bytes;
    }

    public static String randomIp() {
        int[] range = (int[])Arrays1.random(IP_RANGE);
        return IPs.intToIp(range[0] + Randoms.randomInt(range[1] - range[0]));
    }

    public static boolean ipInRange(String ipStart, String ipEnd, String ip) {
        long is = IPs.ipToLong(ipStart);
        long ie = IPs.ipToLong(ipEnd);
        long i = IPs.ipToLong(ip);
        return is <= i && i <= ie;
    }

    public static long ipToLong(String ip) {
        String[] ips = ip.trim().split("\\.");
        long ipLong = 0L;
        for (int i = 0; i < 4; ++i) {
            ipLong = ipLong << 8 | (long)Integer.parseInt(ips[i]);
        }
        return ipLong;
    }

    public static String longToIp(long ip) {
        return IPs.intToIp((int)ip);
    }

    public static String intToIp(int ip) {
        int[] b = new int[]{ip >> 24 & 0xFF, ip >> 16 & 0xFF, ip >> 8 & 0xFF, ip & 0xFF};
        return b[0] + "." + b[1] + "." + b[2] + "." + b[3];
    }

    public static boolean ping(String ip) {
        return IPs.ping(ip, 1000);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getHostIp(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
    }

    public static String getDefaultHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
    }

    public static String getDefaultHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static Map<String, String> getLocalHosts() {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            InetAddress[] allAddress;
            for (InetAddress address : allAddress = InetAddress.getAllByName(IPs.getDefaultHostName())) {
                result.put(address.getHostAddress().split("%")[0], address.getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static NetworkInterface getDefaultNetwork() {
        try {
            return NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static NetworkInterface getNetworkByName(String networkName) {
        try {
            return NetworkInterface.getByName(networkName);
        }
        catch (SocketException e) {
            return null;
        }
    }

    public static List<String> getNetworkAddresses(String networkName) {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(networkName);
            return networkInterface.getInterfaceAddresses().stream().map(s -> s.getAddress().getHostAddress()).map(s -> s.contains("%") ? s.split("%")[0] : s).collect(Collectors.toList());
        }
        catch (SocketException e) {
            return new ArrayList<String>();
        }
    }

    public static List<String> getNetworkNames() {
        try {
            return Lists.as(NetworkInterface.getNetworkInterfaces()).stream().map(NetworkInterface::getName).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static String getMacAddress(InetAddress address) {
        if (address == null) {
            return null;
        }
        try {
            byte[] mac = NetworkInterface.getByInetAddress(address).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(':');
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InetSocketAddress createAddress(int port) {
        return new InetSocketAddress(port);
    }

    public static InetSocketAddress createAddress(String host, int port) {
        return Strings.isBlank(host) ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
    }

    static {
        String i = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (!(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                    i = ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        IP = i;
        IP_RANGE = new int[][]{{607649792, 608174079}, {1038614528, 1039007743}, {1783627776, 1784676351}, {2035023872, 2035154943}, {2078801920, 2079064063}, {-1950089216, -1948778497}, {-1425539072, -1425014785}, {-1236271104, -1235419137}, {-770113536, -768606209}, {-569376768, -564133889}};
    }
}

