/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.random;

import cn.orionsec.kit.lang.utils.Strings;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class Randoms {
    public static final Random RANDOM = new Random();
    private static final String ALL = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LETTER = "abcdefghijkllmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String NUMBER = "0123456789";

    private Randoms() {
    }

    public static Random getRandom() {
        return RANDOM;
    }

    public static Random getRandom(boolean threadLocal) {
        return threadLocal ? ThreadLocalRandom.current() : RANDOM;
    }

    public static char randomChineseChar() {
        return Strings.randomChar().charAt(0);
    }

    public static String randomChineseString() {
        return Strings.randomChar();
    }

    public static String randomChineseString(int count) {
        return Strings.randomChars(count);
    }

    public static String randomAscii(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(ALL.charAt(random.nextInt(ALL.length())));
        }
        return sb.toString();
    }

    public static String randomLetter(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(LETTER.charAt(random.nextInt(LETTER.length())));
        }
        return sb.toString();
    }

    public static int randomInt() {
        return Randoms.randomInt(0, Integer.MAX_VALUE);
    }

    public static int randomInt(int max) {
        return Randoms.randomInt(0, max);
    }

    public static int randomInt(int min, int max) {
        return RANDOM.nextInt(max - min) + min;
    }

    public static double randomDouble() {
        return Randoms.randomDouble(0.0, Double.MAX_VALUE);
    }

    public static double randomDouble(double max) {
        return Randoms.randomDouble(0.0, max);
    }

    public static double randomDouble(double min, double max) {
        return RANDOM.nextDouble() * (max - min) + min;
    }

    public static long randomLong() {
        return Randoms.randomLong(0L, Long.MAX_VALUE);
    }

    public static long randomLong(long max) {
        return Randoms.randomLong(0L, max);
    }

    public static long randomLong(long min, long max) {
        return (long)(RANDOM.nextDouble() * (double)(max - min)) + min;
    }

    public static boolean randomBoolean() {
        return RANDOM.nextDouble() < 0.5;
    }

    public static boolean randomBoolean(int ratio) {
        return RANDOM.nextInt(ratio) == ratio - 1;
    }

    public static boolean randomBoolean(double ratio) {
        return RANDOM.nextDouble() < ratio;
    }

    public static String randomNumber(int length) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append(NUMBER.charAt(random.nextInt(NUMBER.length())));
        }
        return sb.toString();
    }

    public static <E> ArrayRandom<E> randomArray(E[] array) {
        return new ArrayRandom(array);
    }

    public static <E> ListRandom<E> randomList(List<E> list) {
        return new ListRandom(list);
    }

    public static class ListRandom<E> {
        private final List<E> list;
        private Integer len;
        private final Random r = new Random();
        private final Object lock = new Object();

        private ListRandom(List<E> list) {
            this.list = list;
            this.len = list.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E next() {
            Object object = this.lock;
            synchronized (object) {
                if (this.len <= 0) {
                    return null;
                }
                if (this.len == 1) {
                    this.len = this.len - 1;
                    return this.list.get(this.len);
                }
                int index = this.r.nextInt(this.len);
                if (index == this.len - 1) {
                    this.len = this.len - 1;
                    return this.list.get(this.len);
                }
                E c = this.list.get(index);
                this.len = this.len - 1;
                this.list.set(index, this.list.get(this.len));
                return c;
            }
        }
    }

    public static class ArrayRandom<E> {
        private final E[] array;
        private Integer len;
        private final Random r = new Random();
        private final Object lock = new Object();

        private ArrayRandom(E[] array) {
            this.array = array;
            this.len = array.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E next() {
            Object object = this.lock;
            synchronized (object) {
                if (this.len <= 0) {
                    return null;
                }
                if (this.len == 1) {
                    this.len = this.len - 1;
                    return this.array[this.len];
                }
                int index = this.r.nextInt(this.len);
                if (index == this.len - 1) {
                    this.len = this.len - 1;
                    return this.array[this.len];
                }
                E c = this.array[index];
                this.len = this.len - 1;
                this.array[index] = this.array[this.len];
                return c;
            }
        }
    }
}

