/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.reflect;

import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.collect.Lists;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Classes {
    private static final List<String> PROXY_CLASS_NAMES = new ArrayList<String>();
    private static final ClassLoader CURRENT_CLASS_LOADER;
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final Class<?>[] BASE_CLASS;
    private static final Class<?>[] WRAP_CLASS;
    private static final Class<?>[] BASE_ARRAY_CLASS;
    private static final Class<?>[] WRAP_ARRAY_CLASS;

    private Classes() {
    }

    public static ClassLoader getCurrentClassLoader() {
        return CURRENT_CLASS_LOADER;
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, boolean init) {
        try {
            return Class.forName(className, init, CURRENT_CLASS_LOADER);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, boolean init, ClassLoader classLoader) {
        try {
            return Class.forName(className, init, classLoader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR)) {
                return true;
            }
            for (Class<?> cls : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJdkProxy(Object o) {
        return o != null && Proxy.isProxyClass(o.getClass());
    }

    public static boolean isCglibProxy(Object o) {
        return o != null && o.getClass().toString().contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> getSuperClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        Class<?> superClass = clazz.getSuperclass();
        if (!clazz.getName().contains(CGLIB_CLASS_SEPARATOR)) {
            return superClass;
        }
        return Object.class;
    }

    public static List<Class<?>> getSuperClasses(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        if (!clazz.getName().contains(CGLIB_CLASS_SEPARATOR)) {
            ArrayList list = new ArrayList();
            for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                list.add(superClass);
            }
            return list;
        }
        return new ArrayList();
    }

    public static List<Class<?>> getInterfaces(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        if (clazz.isInterface()) {
            return Lists.of(clazz);
        }
        HashSet interfaces = new HashSet();
        while (clazz != null) {
            Class<?>[] ins;
            for (Class<?> in : ins = clazz.getInterfaces()) {
                interfaces.addAll(Classes.getInterfaces(in));
            }
            clazz = clazz.getSuperclass();
        }
        return new ArrayList(interfaces);
    }

    public static boolean isInterface(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        return Modifier.isInterface(clazz.getModifiers());
    }

    public static boolean isImplClass(Class<?> requireClass, Class<?> argClass) {
        Valid.notNull(requireClass, "require class is null", new Object[0]);
        Valid.notNull(argClass, "arg class is null", new Object[0]);
        if (requireClass.equals(argClass) || requireClass.equals(Object.class)) {
            return true;
        }
        return requireClass.isAssignableFrom(argClass);
    }

    public static boolean isArray(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        return clazz.isArray();
    }

    public static boolean isBaseClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (Class<?> baseClass : BASE_CLASS) {
            if (!clazz.equals(baseClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWrapClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (Class<?> wrapClass : WRAP_CLASS) {
            if (!clazz.equals(wrapClass)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getWrapClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (int i = 0; i < BASE_CLASS.length; ++i) {
            if (!clazz.equals(BASE_CLASS[i])) continue;
            return WRAP_CLASS[i];
        }
        return clazz;
    }

    public static Class<?> getBaseClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (int i = 0; i < WRAP_CLASS.length; ++i) {
            if (!clazz.equals(WRAP_CLASS[i])) continue;
            return BASE_CLASS[i];
        }
        return clazz;
    }

    public static boolean isBaseArrayClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (Class<?> baseClass : BASE_ARRAY_CLASS) {
            if (!clazz.equals(baseClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWrapArrayClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (Class<?> wrapClass : WRAP_ARRAY_CLASS) {
            if (!clazz.equals(wrapClass)) continue;
            return true;
        }
        return false;
    }

    public static Class<?> getWrapArrayClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (int i = 0; i < BASE_ARRAY_CLASS.length; ++i) {
            if (!clazz.equals(BASE_ARRAY_CLASS[i])) continue;
            return WRAP_ARRAY_CLASS[i];
        }
        return clazz;
    }

    public static Class<?> getBaseArrayClass(Class<?> clazz) {
        Valid.notNull(clazz, "class is null", new Object[0]);
        for (int i = 0; i < WRAP_ARRAY_CLASS.length; ++i) {
            if (!clazz.equals(WRAP_ARRAY_CLASS[i])) continue;
            return BASE_ARRAY_CLASS[i];
        }
        return clazz;
    }

    public static boolean isNumberClass(Class<?> clazz) {
        boolean direct;
        Valid.notNull(clazz, "class is null", new Object[0]);
        boolean bl = direct = clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Number.class;
        if (direct) {
            return direct;
        }
        for (Class<?> superClass = clazz.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            if (superClass != Number.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumberClass(Object o) {
        Valid.notNull(o, "object is null", new Object[0]);
        return o instanceof Number;
    }

    static {
        BASE_CLASS = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE};
        WRAP_CLASS = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class};
        BASE_ARRAY_CLASS = new Class[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class};
        WRAP_ARRAY_CLASS = new Class[]{Byte[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Boolean[].class, Character[].class};
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        CURRENT_CLASS_LOADER = contextClassLoader != null ? contextClassLoader : Classes.class.getClassLoader();
        PROXY_CLASS_NAMES.add("net.sf.cglib.proxy.Factory");
        PROXY_CLASS_NAMES.add("org.springframework.cglib.proxy.Factory");
        PROXY_CLASS_NAMES.add("javassist.util.proxy.ProxyObject");
        PROXY_CLASS_NAMES.add("org.apache.ibatis.javassist.util.proxy.ProxyObject");
    }
}

