/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.regexp;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.config.KitConfig;
import cn.orionsec.kit.lang.define.cache.SoftCache;
import java.util.regex.Pattern;

public class Patterns {
    private static final SoftCache<String, Pattern> CACHE = new SoftCache();
    public static final Pattern SPACE_LINE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_SPACE_LINE);
    public static final Pattern SPACE_POINT = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_SPACE_POINT);
    public static final Pattern PHONE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_PHONE);
    public static final Pattern EMAIL = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_EMAIL);
    public static final Pattern HTTP = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_HTTP);
    public static final Pattern URI = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_URI);
    public static final Pattern INTEGER = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_INTEGER);
    public static final Pattern DOUBLE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_DOUBLE);
    public static final Pattern NUMBER = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_NUMBER);
    public static final Pattern NUMBER_EXT = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_NUMBER_EXT);
    public static final Pattern IPV4 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_IPV4);
    public static final Pattern IPV6 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_IPV6);
    public static final Pattern MD5 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_MD5);
    public static final Pattern WINDOWS_PATH = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_WINDOWS_PATH);
    public static final Pattern LINUX_PATH = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_LINUX_PATH);
    public static final Pattern ZIP_CODE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_ZIP_CODE);
    public static final Pattern UTF = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_UTF);
    public static final Pattern UUID = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_UUID);
    public static final Pattern MAC = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_MAC);
    public static final Pattern HEX = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_HEX);
    public static final Pattern CREDIT_CODE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_CREDIT_CODE);
    public static final Pattern ID_CARD = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_ID_CARD);
    public static final Pattern PLATE_NUMBER = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_PLATE_NUMBER);
    public static final Pattern HEX_COLOR = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_HEX_COLOR);
    public static final Pattern DATE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_DATE);
    public static final Pattern WE_CHAT = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_WE_CHAT);
    public static final Pattern QQ = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_QQ);
    public static final Pattern CHINESE = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_CHINESE);
    public static final Pattern USERNAME_1 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_USERNAME_1);
    public static final Pattern USERNAME_2 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_USERNAME_2);
    public static final Pattern PASSWORD_1 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_PASSWORD_1);
    public static final Pattern PASSWORD_2 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_PASSWORD_2);
    public static final Pattern PASSWORD_3 = (Pattern)KitConfig.get(KitLangConfiguration.CONFIG.PATTERN_PASSWORD_3);

    private Patterns() {
    }

    public static Pattern getPattern(String pattern) {
        Pattern p = CACHE.get(pattern);
        if (p == null) {
            p = Pattern.compile(pattern);
            CACHE.put(pattern, p);
        }
        return p;
    }

    public static Pattern getPatternExt(Pattern pattern) {
        return Patterns.getPatternExt(pattern.pattern());
    }

    public static Pattern getPatternExt(String pattern) {
        Pattern p;
        if (pattern.startsWith("^")) {
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith("$")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if ((p = CACHE.get(pattern)) == null) {
            p = Pattern.compile(pattern);
            CACHE.put(pattern, p);
        }
        return p;
    }
}

