/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.unit;

import java.math.BigDecimal;
import java.math.RoundingMode;

public enum WeightUnit {
    MG{

        @Override
        public BigDecimal toMilligram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toGram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode);
        }

        @Override
        public BigDecimal toKilogram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode).divide(THOUSAND, roundingMode);
        }

        @Override
        public BigDecimal toTon(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode).divide(THOUSAND, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    G{

        @Override
        public BigDecimal toMilligram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toGram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toKilogram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode);
        }

        @Override
        public BigDecimal toTon(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    KG{

        @Override
        public BigDecimal toMilligram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toGram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toKilogram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u;
        }

        @Override
        public BigDecimal toTon(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).divide(THOUSAND, roundingMode);
        }
    }
    ,
    T{

        @Override
        public BigDecimal toMilligram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND).multiply(THOUSAND).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toGram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toKilogram(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode).multiply(THOUSAND);
        }

        @Override
        public BigDecimal toTon(BigDecimal u, int scale, RoundingMode roundingMode) {
            return u.setScale(scale, roundingMode);
        }
    };

    private static final BigDecimal THOUSAND;
    private static final int DEFAULT_SCALE = 4;
    private static final RoundingMode DEFAULT_ROUND_MODE;

    public BigDecimal toMilligram(long u) {
        return this.toMilligram(BigDecimal.valueOf(u), 4, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toMilligram(long u, int scale, RoundingMode roundingMode) {
        return this.toMilligram(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toMilligram(BigDecimal u) {
        return this.toMilligram(u, 4, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toMilligram(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toGram(long u) {
        return this.toGram(BigDecimal.valueOf(u), 4, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toGram(long u, int scale, RoundingMode roundingMode) {
        return this.toGram(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toGram(BigDecimal u) {
        return this.toGram(u, 4, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toGram(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toKilogram(long u) {
        return this.toKilogram(BigDecimal.valueOf(u), 4, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toKilogram(long u, int scale, RoundingMode roundingMode) {
        return this.toKilogram(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toKilogram(BigDecimal u) {
        return this.toKilogram(u, 4, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toKilogram(BigDecimal var1, int var2, RoundingMode var3);

    public BigDecimal toTon(long u) {
        return this.toTon(BigDecimal.valueOf(u), 4, DEFAULT_ROUND_MODE);
    }

    public BigDecimal toTon(long u, int scale, RoundingMode roundingMode) {
        return this.toTon(BigDecimal.valueOf(u), scale, roundingMode);
    }

    public BigDecimal toTon(BigDecimal u) {
        return this.toTon(u, 4, DEFAULT_ROUND_MODE);
    }

    public abstract BigDecimal toTon(BigDecimal var1, int var2, RoundingMode var3);

    static {
        THOUSAND = BigDecimal.valueOf(1000L);
        DEFAULT_ROUND_MODE = RoundingMode.FLOOR;
    }
}

