/*
 * Copyright (c) 2019 - present Jiahang Li, All rights reserved.
 *
 *   https://kit.orionsec.cn
 *
 * Members:
 *   Jiahang Li - ljh1553488six@139.com - author
 *
 * The MIT License (MIT)
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package cn.orionsec.kit.lang.constant;

/**
 * 符号常量
 *
 * @author Jiahang Li
 * @version 1.0.0
 * @since 2021/1/21 16:06
 */
public interface Letters {

    char LF = '\n';

    char CR = '\r';

    char QUOTE = '"';

    char SINGLE_QUOTE = '\'';

    char UNDERLINE = '_';

    char DASHED = '-';

    char COLON = ':';

    char COMMA = ',';

    char SPACE = ' ';

    char DOT = '.';

    char TAB = '\t';

    char POUND = '#';

    char DOLLAR = '$';

    char SLASH = '/';

    char BACKSLASH = '\\';

    char AMP = '&';

    char AT = '@';

    char ASTERISK = '*';

    char PLUS = '+';

    char EQUALS = '=';

    char PIPE = '|';

    char SEMICOLON = ';';

    char EXCLAMATION = '!';

    char PERCENT = '%';

    char CARET = '^';

    char QUESTION = '?';

    char NULL = '\0';

    char BACKSPACE = '\b';

    char FORM_FEED = '\f';

    char ESCAPE = '\u001B';

    char VERTICAL_TAB = '\u000B';

    char ALERT = '\u0007';

}
