/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache;

import cn.orionsec.kit.lang.define.cache.TimedCache;
import cn.orionsec.kit.lang.define.cache.TimedCacheChecker;
import cn.orionsec.kit.lang.define.cache.TimedCacheValue;
import cn.orionsec.kit.lang.utils.Objects1;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TimedCacheImpl<T>
implements TimedCache<T> {
    private final int expireAfter;
    private final Map<String, TimedCacheValue<T>> store;
    private final TimedCacheChecker<T> checker;

    TimedCacheImpl(int expireAfter, Map<String, TimedCacheValue<T>> store, TimedCacheChecker<T> checker) {
        this.expireAfter = expireAfter;
        this.store = store;
        this.checker = checker;
        checker.start();
    }

    @Override
    public T put(String key, T value) {
        TimedCacheValue<T> returnValue = this.store.put(key, this.createValue(value));
        return this.safeGet(returnValue);
    }

    @Override
    public T put(String key, T value, long expireAfter) {
        TimedCacheValue<T> returnValue = this.store.put(key, this.createValue(value, expireAfter));
        return this.safeGet(returnValue);
    }

    @Override
    public T putIfAbsent(String key, T value) {
        TimedCacheValue<T> returnValue = this.store.putIfAbsent(key, this.createValue(value));
        return this.safeGet(returnValue);
    }

    @Override
    public T putIfAbsent(String key, T value, long expireAfter) {
        TimedCacheValue<T> returnValue = this.store.putIfAbsent(key, this.createValue(value, expireAfter));
        return this.safeGet(returnValue);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        map.forEach((k, v) -> this.store.put((String)k, this.createValue(v)));
    }

    @Override
    public T get(Object key) {
        return this.getOrDefault(key, (T)null);
    }

    @Override
    public T getOrDefault(Object key, T defaultValue) {
        TimedCacheValue<T> value = this.store.get((String)key);
        return Objects1.def(this.safeGet(value), defaultValue);
    }

    @Override
    public T remove(Object key) {
        return this.safeGet(this.store.remove(key));
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.store.values().stream().anyMatch(v -> Objects.equals(value, v.value));
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.store.keySet();
    }

    @Override
    public Collection<T> values() {
        return this.store.values().stream().map(this::safeGet).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.store.keySet().stream().map(s -> new AbstractMap.SimpleEntry<String, T>((String)s, this.safeGet(this.store.get(s)))).collect(Collectors.toSet());
    }

    @Override
    public Map<String, TimedCacheValue<T>> getStore() {
        return this.store;
    }

    private T safeGet(TimedCacheValue<T> value) {
        if (value == null) {
            return null;
        }
        return value.value;
    }

    private TimedCacheValue<T> createValue(T o) {
        return this.createValue(o, this.expireAfter);
    }

    private TimedCacheValue<T> createValue(T o, long expireAfter) {
        return new TimedCacheValue<T>(System.currentTimeMillis() + expireAfter, o);
    }

    @Override
    public void close() {
        this.store.clear();
        this.checker.close();
    }

    public String toString() {
        return this.store.toString();
    }
}

