/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.cache.key;

import cn.orionsec.kit.lang.able.Buildable;
import cn.orionsec.kit.lang.define.cache.key.CacheKeyDefine;
import cn.orionsec.kit.lang.define.cache.key.struct.CacheStruct;
import java.util.concurrent.TimeUnit;

public class CacheKeyBuilder
implements Buildable<CacheKeyDefine> {
    private String key;
    private String prefix;
    private String desc;
    private Class<?> type;
    private CacheStruct struct = CacheKeyDefine.DEFAULT_STRUCT;
    private long timeout = 0L;
    private TimeUnit unit = CacheKeyDefine.DEFAULT_UNIT;

    public static CacheKeyBuilder create() {
        return new CacheKeyBuilder();
    }

    public CacheKeyBuilder key(String key) {
        this.key = key;
        return this;
    }

    public CacheKeyBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public CacheKeyBuilder noPrefix() {
        this.prefix = "";
        return this;
    }

    public CacheKeyBuilder desc(String desc) {
        this.desc = desc;
        return this;
    }

    public CacheKeyBuilder type(Class<?> type) {
        this.type = type;
        return this;
    }

    public CacheKeyBuilder struct(CacheStruct struct) {
        this.struct = struct;
        return this;
    }

    public CacheKeyBuilder timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public CacheKeyBuilder timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        return this;
    }

    public CacheKeyBuilder unit(TimeUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public CacheKeyDefine build() {
        return new CacheKeyDefine(this.key, this.prefix, this.desc, this.type, this.struct, this.timeout, this.unit);
    }
}

