/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.collect;

import cn.orionsec.kit.lang.KitLangConfiguration;
import cn.orionsec.kit.lang.config.KitConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LimitList<E>
extends ArrayList<E>
implements Serializable {
    private static final long serialVersionUID = 829347812390094123L;
    private static final int LIMIT_LIST_DEFAULT_LIMIT = (Integer)KitConfig.get(KitLangConfiguration.CONFIG.LIMIT_LIST_DEFAULT_LIMIT);
    private int limit;

    public LimitList() {
        this(LIMIT_LIST_DEFAULT_LIMIT);
    }

    public LimitList(int limit) {
        this.limit = limit;
    }

    public LimitList(int initialCapacity, int limit) {
        super(initialCapacity);
        this.limit = limit;
    }

    public LimitList(Collection<? extends E> c) {
        this(c, LIMIT_LIST_DEFAULT_LIMIT);
    }

    public LimitList(Collection<? extends E> c, int limit) {
        super(c);
        this.limit = limit;
    }

    public static <E> LimitList<E> create() {
        return new LimitList<E>();
    }

    public static <E> LimitList<E> create(int limit) {
        return new LimitList<E>(limit);
    }

    public static <E> LimitList<E> create(int initialCapacity, int limit) {
        return new LimitList<E>(initialCapacity, limit);
    }

    public static <E> LimitList<E> create(Collection<? extends E> c) {
        return new LimitList<E>(c);
    }

    public static <E> LimitList<E> create(Collection<? extends E> c, int limit) {
        return new LimitList<E>(c, limit);
    }

    public LimitList<E> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public List<E> page(int p) {
        int offset = (p - 1) * this.limit;
        int size = this.size();
        int end = offset + this.limit;
        int re = Math.min(end, size);
        ArrayList list = new ArrayList(re);
        for (int i = offset; i < re; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getTotal() {
        return this.size();
    }

    public int getPages() {
        int size = this.size();
        return size % this.limit == 0 ? size / this.limit : size / this.limit + 1;
    }
}

