/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.define.mutable;

import cn.orionsec.kit.lang.able.Mutable;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.Urls;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.Xsses;
import cn.orionsec.kit.lang.utils.codec.Base64s;
import cn.orionsec.kit.lang.utils.convert.Converts;
import cn.orionsec.kit.lang.utils.crypto.Signatures;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

public class MutableString
implements Mutable<String>,
CharSequence,
Serializable {
    private static final long serialVersionUID = 8675244107435484L;
    private StringBuilder builder;

    public MutableString() {
        this.builder = new StringBuilder();
    }

    public MutableString(String s) {
        Valid.notNull(s);
        this.builder = new StringBuilder(s);
    }

    public MutableString(StringBuilder builder) {
        Valid.notNull(builder);
        this.builder = builder;
    }

    public MutableString(Object o) {
        Valid.notNull(o);
        this.builder = new StringBuilder(Strings.str(o));
    }

    public static MutableString create() {
        return new MutableString();
    }

    public static MutableString of(String s) {
        return new MutableString(s);
    }

    @Override
    public String get() {
        return this.builder.toString();
    }

    @Override
    public void set(String s) {
        Valid.notNull(s);
        this.builder = new StringBuilder(s);
    }

    public boolean isBlank() {
        return Strings.isBlank(this.builder.toString());
    }

    public boolean isNotBlank() {
        return Strings.isNotBlank(this.builder.toString());
    }

    @Override
    public boolean isEmpty() {
        return Strings.isEmpty(this.builder);
    }

    public boolean isNotEmpty() {
        return Strings.isNotEmpty(this.builder);
    }

    public MutableString trim() {
        this.builder = new StringBuilder(this.builder.toString().trim());
        return this;
    }

    public MutableString trimPunct() {
        this.builder = new StringBuilder(Strings.trimPunct(this.builder.toString()));
        return this;
    }

    public MutableString concat(String ... ss) {
        for (String s : ss) {
            this.builder.append(s);
        }
        return this;
    }

    public MutableString concatBefore(String ... ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            sb.append(s);
        }
        this.builder = sb.append((CharSequence)this.builder);
        return this;
    }

    public MutableString format(Object ... os) {
        this.builder = new StringBuilder(Strings.format(this.builder.toString(), os));
        return this;
    }

    public MutableString reverse() {
        this.builder.reverse();
        return this;
    }

    public MutableString substring(int begin, int end) {
        this.builder = new StringBuilder(this.builder.substring(begin, end));
        return this;
    }

    public MutableString substring(int begin) {
        this.builder = new StringBuilder(this.builder.substring(begin));
        return this;
    }

    public boolean contains(String s) {
        return this.builder.indexOf(s) > -1;
    }

    public Byte toByte() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toByte(this.builder.toString());
    }

    public Short toShort() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toShort(this.builder.toString());
    }

    public Integer toInteger() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toInt(this.builder.toString());
    }

    public Long toLong() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toLong(this.builder.toString());
    }

    public Float toFloat() {
        if (this.isEmpty()) {
            return null;
        }
        return Float.valueOf(Converts.toFloat(this.builder.toString()));
    }

    public Double toDouble() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toDouble(this.builder.toString());
    }

    public Boolean toBoolean() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toBoolean(this.builder.toString());
    }

    public Character toCharacter() {
        if (this.isEmpty()) {
            return null;
        }
        return Character.valueOf(Converts.toChar(this.builder.toString()));
    }

    public Date toDate() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toDate(this.builder.toString());
    }

    public LocalDateTime toLocalDateTime() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toLocalDateTime(this.builder.toString());
    }

    public LocalDate toLocalDate() {
        if (this.isEmpty()) {
            return null;
        }
        return Converts.toLocalDate(this.builder.toString());
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.builder);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.builder);
    }

    public byte[] toBytes() {
        return Strings.bytes(this.builder.toString());
    }

    public byte[] toBytes(String charset) {
        return Strings.bytes(this.builder.toString(), charset);
    }

    public char[] toChars() {
        return this.builder.toString().toCharArray();
    }

    public String toLowerString() {
        return this.builder.toString().toLowerCase();
    }

    public String toUpperString() {
        return this.builder.toString().toUpperCase();
    }

    public String urlEncode() {
        return Urls.encode(this.builder.toString());
    }

    public String urlEncode(String charset) {
        return Urls.encode(this.builder.toString(), charset);
    }

    public String urlDecode() {
        return Urls.decode(this.builder.toString());
    }

    public String urlDecode(String charset) {
        return Urls.decode(this.builder.toString(), charset);
    }

    public String md5() {
        return Signatures.md5(this.builder.toString());
    }

    public String sign(String sign) {
        return Signatures.sign(this.builder.toString(), sign);
    }

    public String encodeBase64() {
        return Base64s.encode(this.builder.toString());
    }

    public String decodeBase64() {
        return Base64s.decode(this.builder.toString());
    }

    public String cleanXss() {
        return Xsses.clean(this.builder.toString());
    }

    public String recodeXss() {
        return Xsses.recode(this.builder.toString());
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutableString that = (MutableString)o;
        return Objects.equals(this.builder, that.builder);
    }

    public int hashCode() {
        return Objects.hash(this.builder);
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }
}

