/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.utils.Arrays1;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Stacks {
    private Stacks() {
    }

    public static List<StackTrace> currentStacks() {
        return Stacks.currentStacks(Stacks.current());
    }

    public static List<StackTrace> currentStacks(Exception e) {
        return Stacks.currentStacks(e.getStackTrace());
    }

    public static List<StackTrace> currentStacks(StackTraceElement[] stackTrace) {
        ArrayList<StackTrace> r = new ArrayList<StackTrace>();
        for (StackTraceElement traceElement : stackTrace) {
            r.add(new StackTrace(traceElement));
        }
        return r;
    }

    public static StackTrace currentStack(int index) {
        return Stacks.currentStack(Stacks.current(), index);
    }

    public static StackTrace currentStack(Exception e, int index) {
        return Stacks.currentStack(e.getStackTrace(), index);
    }

    public static StackTrace currentStack(StackTraceElement[] stackTrace, int index) {
        return new StackTrace(stackTrace[index]);
    }

    public static StackTrace currentStack() {
        return Stacks.currentStack(Stacks.current());
    }

    public static StackTrace currentStack(Exception e) {
        return Stacks.currentStack(e.getStackTrace());
    }

    public static StackTrace currentStack(StackTraceElement[] stackTrace) {
        return new StackTrace(Arrays1.last(stackTrace));
    }

    public static String currentFile() {
        return Stacks.currentFile(Stacks.current());
    }

    public static String currentFile(Exception e) {
        return Stacks.currentFile(e.getStackTrace());
    }

    public static String currentFile(StackTraceElement[] stackTrace) {
        return Arrays1.last(stackTrace).getFileName();
    }

    public static String currentClass() {
        return Stacks.currentClass(Stacks.current());
    }

    public static String currentClass(Exception e) {
        return Stacks.currentClass(e.getStackTrace());
    }

    public static String currentClass(StackTraceElement[] stackTrace) {
        return Arrays1.last(stackTrace).getClassName();
    }

    public static String currentMethod() {
        return Stacks.currentMethod(Stacks.current());
    }

    public static String currentMethod(Exception e) {
        return Stacks.currentMethod(e.getStackTrace());
    }

    public static String currentMethod(StackTraceElement[] stackTrace) {
        return Arrays1.last(stackTrace).getMethodName();
    }

    public static int currentLineNumber() {
        return Stacks.currentLineNumber(Stacks.current());
    }

    public static int currentLineNumber(Exception e) {
        return Stacks.currentLineNumber(e.getStackTrace());
    }

    public static int currentLineNumber(StackTraceElement[] stackTrace) {
        return Arrays1.last(stackTrace).getLineNumber();
    }

    public static boolean currentNative() {
        return Stacks.currentNative(Stacks.current());
    }

    public static boolean currentNative(Exception e) {
        return Stacks.currentNative(e.getStackTrace());
    }

    public static boolean currentNative(StackTraceElement[] stackTrace) {
        return Arrays1.last(stackTrace).isNativeMethod();
    }

    public static StackTrace toStackTrace(StackTraceElement e) {
        return new StackTrace(e);
    }

    public static List<StackTrace> toStackTraces(StackTraceElement[] es) {
        ArrayList<StackTrace> list = new ArrayList<StackTrace>();
        for (StackTraceElement e : es) {
            list.add(new StackTrace(e));
        }
        return list;
    }

    private static StackTraceElement[] current() {
        return Thread.currentThread().getStackTrace();
    }

    public static class StackTrace
    implements Serializable {
        private final StackTraceElement e;
        private final String className;
        private final String fileName;
        private final Integer lineNumber;
        private final String methodName;
        private final boolean nativeMethod;

        private StackTrace(StackTraceElement e) {
            this.e = e;
            this.className = e.getClassName();
            this.fileName = e.getFileName();
            this.lineNumber = e.getLineNumber();
            this.methodName = e.getMethodName();
            this.nativeMethod = e.isNativeMethod();
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public boolean isNativeMethod() {
            return this.nativeMethod;
        }

        public String toRawString() {
            return this.e.toString();
        }

        public String toString() {
            return this.e + "\n     className ==> '" + this.className + '\'' + "\n      fileName ==> '" + this.fileName + '\'' + "\n    lineNumber ==> " + this.lineNumber + "\n    methodName ==> '" + this.methodName + '\'' + "\n  nativeMethod ==> " + this.nativeMethod;
        }
    }
}

