/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils;

import cn.orionsec.kit.lang.define.collect.MutableHashMap;
import cn.orionsec.kit.lang.define.mutable.MutableString;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Urls {
    private Urls() {
    }

    public static String getUrlSource(String url) {
        String[] uri = url.split("/");
        return uri[uri.length - 1].split("\\?")[0];
    }

    public static String buildQueryString(Map<String, ?> request) {
        return Urls.buildQueryString(request, null, false, null);
    }

    public static String buildQueryString(Map<String, ?> request, boolean encode) {
        return Urls.buildQueryString(request, null, encode, null);
    }

    public static String buildQueryString(Map<String, ?> request, boolean encode, String encodeCharset) {
        return Urls.buildQueryString(request, null, encode, encodeCharset);
    }

    public static String buildQueryString(Map<String, ?> request, List<String> skipFields) {
        return Urls.buildQueryString(request, skipFields, false, null);
    }

    public static String buildQueryString(Map<String, ?> request, List<String> skipFields, boolean encode) {
        return Urls.buildQueryString(request, skipFields, encode, null);
    }

    public static String buildQueryString(Map<String, ?> request, List<String> skipFields, boolean encode, String encodeCharset) {
        if (request == null || request.isEmpty()) {
            return "";
        }
        ArrayList<String> fieldNames = new ArrayList<String>(request.keySet());
        Collections.sort(fieldNames);
        StringBuilder sb = Strings.newBuilder();
        for (String fieldName : fieldNames) {
            String fieldValue = "";
            Object o = request.get(fieldName);
            if (o != null) {
                fieldValue = o.toString();
            }
            boolean skip = false;
            if (skipFields != null) {
                for (String skipField : skipFields) {
                    if (skipField == null || fieldName == null || !skipField.trim().equals(fieldName.trim())) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            if (Strings.isNotBlank(fieldValue)) {
                if (encode) {
                    sb.append(fieldName).append("=").append(Urls.encode(fieldValue, encodeCharset)).append("&");
                    continue;
                }
                sb.append(fieldName).append("=").append(fieldValue).append("&");
                continue;
            }
            sb.append(fieldName).append("&");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static MutableHashMap<String, String> getQueryString(String url) {
        String[] entries;
        MutableHashMap<String, String> map = new MutableHashMap<String, String>();
        if (Strings.isBlank(url)) {
            return map;
        }
        String[] query = (url = Urls.decode(url)).split("\\?");
        if (query.length == 1) {
            entries = query[0].split("&");
        } else if (query.length == 2) {
            entries = query[1].split("&");
        } else {
            return map;
        }
        for (String entry : entries) {
            String[] kv = entry.split("=");
            if (kv.length == 2) {
                map.put(kv[0], kv[1]);
                continue;
            }
            if (kv.length != 1) continue;
            map.put(kv[0], null);
        }
        return map;
    }

    public static MutableString queryExt(String url, String key) {
        return new MutableString(Urls.query(url, key));
    }

    public static String query(String url, String key) {
        MutableHashMap<String, String> queryString = Urls.getQueryString(url);
        for (Map.Entry entry : queryString.entrySet()) {
            if (!((String)entry.getKey()).equals(key)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public static MutableHashMap<String, String> queries(String url, String ... keys) {
        MutableHashMap<String, String> queryString = Urls.getQueryString(url);
        MutableHashMap<String, String> res = new MutableHashMap<String, String>();
        if (keys != null) {
            for (String key : keys) {
                res.put(key, (String)queryString.get(key));
            }
        }
        return res;
    }

    public static String encode(String url) {
        return Urls.encode(url, "UTF-8");
    }

    public static String encode(String url, String charset) {
        try {
            if (charset == null) {
                return URLEncoder.encode(url, "UTF-8");
            }
            return URLEncoder.encode(url, charset);
        }
        catch (Exception e) {
            return url;
        }
    }

    public static String decode(String url) {
        return Urls.decode(url, "UTF-8");
    }

    public static String decode(String url, String charset) {
        try {
            if (charset == null) {
                return URLDecoder.decode(url, "UTF-8");
            }
            return URLDecoder.decode(url, charset);
        }
        catch (Exception e) {
            return url;
        }
    }

    public static InputStream openInputStream(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        return con.getInputStream();
    }

    public static InputStream openInputStream(String url) throws IOException {
        URL u = new URL(url);
        URLConnection con = u.openConnection();
        con.connect();
        return con.getInputStream();
    }

    public static byte[] getUrlBytes(String url) throws IOException {
        URL u = new URL(url);
        HttpURLConnection con = (HttpURLConnection)u.openConnection();
        con.connect();
        return Streams.toByteArray(con.getInputStream());
    }

    public static byte[] getUrlBytes(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        return Streams.toByteArray(con.getInputStream());
    }

    public static UrlStream getUrlStream() {
        return new UrlStream();
    }

    public static class UrlStream {
        private String protocol = "http";
        private String host = "";
        private int port;
        private String path;
        private Map<String, String> query;
        private String queryString;
        private String route;

        private UrlStream() {
        }

        public UrlStream protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public UrlStream host(String host) {
            this.host = host;
            return this;
        }

        public UrlStream port(int port) {
            this.port = port;
            return this;
        }

        public UrlStream path(String path) {
            this.path = path;
            return this;
        }

        public UrlStream query(Map<String, String> query) {
            if (this.query == null) {
                this.query = query;
            } else {
                this.query.putAll(query);
            }
            return this;
        }

        public UrlStream query(String key, String value) {
            if (this.query == null) {
                this.query = new HashMap<String, String>();
            }
            this.query.put(key, value);
            return this;
        }

        public UrlStream route(String route) {
            this.route = route;
            return this;
        }

        public String getUrl() {
            return this.getUrl(false);
        }

        public String getUrl(boolean showPort) {
            this.setProtocolPort();
            StringBuilder sb = new StringBuilder();
            sb.append(this.protocol).append("://").append(this.host);
            if (showPort) {
                sb.append(':').append(this.port);
            }
            if (this.path != null) {
                if (this.path.charAt(0) == '/') {
                    sb.append(this.path);
                } else {
                    sb.append('/').append(this.path);
                }
            }
            if (this.query != null) {
                this.queryString = Urls.buildQueryString(this.query);
                if (!Strings.isBlank(this.queryString)) {
                    sb.append("?");
                }
                sb.append(this.queryString);
            }
            if (this.route != null) {
                if (this.route.charAt(0) == '#') {
                    sb.append(this.route);
                } else {
                    sb.append('#').append(this.route);
                }
            }
            return sb.toString();
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getQuery() {
            return this.query;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getRoute() {
            return this.route;
        }

        public String toString() {
            return this.getUrl(false);
        }

        private void setProtocolPort() {
            if (this.port != 0) {
                return;
            }
            if ("http".equals(this.protocol)) {
                this.port = 80;
            } else if ("https".equals(this.protocol)) {
                this.port = 443;
            } else if ("ftp".equals(this.protocol)) {
                this.port = 21;
            } else if ("ssh".equals(this.protocol)) {
                this.port = 22;
            }
        }
    }
}

