/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.ansi.style.color;

import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.ansi.style.color.AnsiColor;

public abstract class AnsiBitColor
implements AnsiColor {
    private final String code;

    public AnsiBitColor(String code) {
        this.code = code;
    }

    protected static String color(byte type, byte bit, int ... elem) {
        StringBuilder sb = new StringBuilder().append(type).append(";").append(bit).append(";");
        int len = elem.length;
        for (int i = 0; i < len; ++i) {
            int color = elem[i];
            Valid.isTrue(color >= 0 && color <= 255, "color must be between 0 and 255", new Object[0]);
            sb.append(color);
            if (i >= len - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String toString() {
        return "\u001b[" + this.code + "m";
    }
}

