/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.convert;

import cn.orionsec.kit.lang.function.Conversion;
import cn.orionsec.kit.lang.utils.Valid;
import cn.orionsec.kit.lang.utils.convert.TypeStore;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public abstract class TypeMapper<T>
implements Serializable {
    private static final long serialVersionUID = -123903459090989178L;
    private final TypeStore store;
    private final Class<T> sourceType;

    public TypeMapper(Class<T> sourceType) {
        this(sourceType, TypeStore.STORE);
    }

    public TypeMapper(Class<T> sourceType, TypeStore store) {
        Valid.notNull(sourceType, "sourceType is null", new Object[0]);
        Valid.notNull(store, "typeStore is null", new Object[0]);
        this.sourceType = sourceType;
        this.store = store;
    }

    protected <R> void register(Class<R> target, Conversion<T, R> conversion) {
        this.store.register(this.sourceType, target, conversion);
    }

    public <R> Conversion<T, R> get(Class<R> target) {
        return this.store.get(this.sourceType, target);
    }

    public <R> R to(T t, Class<R> target) {
        return this.store.to(t, target);
    }

    public Set<Class<?>> getSuitableClasses() {
        return this.store.getSuitableClasses(this.sourceType);
    }

    public Set<Class<?>> getAllSuitableClasses() {
        return this.store.getSuitableClasses(this.sourceType, true);
    }

    public Map<Class<?>, Conversion<?, ?>> getSuitableConversion() {
        return this.store.getSuitableConversion(this.sourceType);
    }

    public Map<Class<?>, Conversion<?, ?>> getAllSuitableConversion() {
        return this.store.getSuitableConversion(this.sourceType, true);
    }
}

