/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.crypto;

import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.crypto.enums.HashDigest;
import cn.orionsec.kit.lang.utils.crypto.enums.SecretKeySpecMode;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Signatures {
    private Signatures() {
    }

    public static String md5(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.MD5.getMessageDigest());
    }

    public static String md5(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.MD5.getMessageDigest());
    }

    public static String md5(String s, String salt) {
        return Signatures.md5(s, salt, 1);
    }

    public static String md5(byte[] bs, byte[] salt) {
        return Signatures.md5(bs, salt, 1);
    }

    public static String md5(String s, String salt, int times) {
        return Signatures.md5(Strings.bytes(s), Strings.bytes(salt), times);
    }

    public static String md5(byte[] bs, byte[] salt, int times) {
        try {
            MessageDigest digest = HashDigest.MD5.getMessageDigest();
            digest.update(bs);
            for (int i = 0; i < times; ++i) {
                digest.update(salt);
            }
            return Signatures.toHex(digest.digest(bs));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String sha1(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.SHA1.getMessageDigest());
    }

    public static String sha1(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.SHA1.getMessageDigest());
    }

    public static String sha224(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.SHA224.getMessageDigest());
    }

    public static String sha224(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.SHA224.getMessageDigest());
    }

    public static String sha256(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.SHA256.getMessageDigest());
    }

    public static String sha256(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.SHA256.getMessageDigest());
    }

    public static String sha384(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.SHA384.getMessageDigest());
    }

    public static String sha384(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.SHA384.getMessageDigest());
    }

    public static String sha512(String s) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.SHA512.getMessageDigest());
    }

    public static String sha512(byte[] bs) {
        return Signatures.hashSign(bs, HashDigest.SHA512.getMessageDigest());
    }

    public static String sign(String s, String type) {
        return Signatures.hashSign(Strings.bytes(s), HashDigest.getMessageDigest(type));
    }

    public static String sign(byte[] bs, String type) {
        return Signatures.hashSign(bs, HashDigest.getMessageDigest(type));
    }

    public static String hashSign(byte[] bs, MessageDigest digest) {
        byte[] bytes = Signatures.hashSignBytes(bs, digest);
        if (bytes != null) {
            return Signatures.toHex(bytes);
        }
        return null;
    }

    public static byte[] hashSignBytes(byte[] bs, MessageDigest digest) {
        try {
            return digest.digest(bs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String hmacMd5(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_MD5);
    }

    public static String hmacMd5(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_MD5);
    }

    public static String hmacSha1(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_SHA1);
    }

    public static String hmacSha1(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_SHA1);
    }

    public static String hmacSha224(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_SHA224);
    }

    public static String hmacSha224(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_SHA224);
    }

    public static String hmacSha256(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_SHA256);
    }

    public static String hmacSha256(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_SHA256);
    }

    public static String hmacSha384(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_SHA384);
    }

    public static String hmacSha384(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_SHA384);
    }

    public static String hmacSha512(String s, String key) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), SecretKeySpecMode.HMAC_SHA512);
    }

    public static String hmacSha512(byte[] bs, byte[] key) {
        return Signatures.hmacHashSign(bs, key, SecretKeySpecMode.HMAC_SHA512);
    }

    public static String hmacSign(String s, String key, SecretKeySpecMode mode) {
        return Signatures.hmacHashSign(Strings.bytes(s), Strings.bytes(key), mode);
    }

    public static String hmacSign(byte[] bs, byte[] key, SecretKeySpecMode mode) {
        return Signatures.hmacHashSign(bs, key, mode);
    }

    public static String hmacHashSign(byte[] bs, byte[] key, SecretKeySpecMode mode) {
        byte[] bytes = Signatures.hmacHashSignBytes(bs, key, mode);
        if (bytes != null) {
            return Signatures.toHex(bytes);
        }
        return null;
    }

    public static byte[] hmacHashSignBytes(byte[] bs, byte[] key, SecretKeySpecMode mode) {
        try {
            SecretKeySpec secretKey = mode.getSecretKeySpec(key);
            Mac mac = Mac.getInstance(mode.getMode());
            mac.init(secretKey);
            return mac.doFinal(bs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toHex(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bs) {
            sb.append(Integer.toHexString(0xFF & b | 0xFFFFFF00).substring(6));
        }
        return sb.toString();
    }
}

