/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.hash;

import cn.orionsec.kit.lang.utils.hash.Hashes;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.ToIntFunction;

public class ConsistentHash<T> {
    private final ToIntFunction<Object> hashFun;
    private final int numberOfReplicas;
    private final SortedMap<Integer, T> circle = new TreeMap<Integer, T>();

    public ConsistentHash(int numberOfReplicas, Collection<T> nodes) {
        this(o -> Hashes.fnvHash(o.toString()), numberOfReplicas, nodes);
    }

    public ConsistentHash(ToIntFunction<Object> hashFun, int numberOfReplicas, Collection<T> nodes) {
        this.numberOfReplicas = numberOfReplicas;
        this.hashFun = hashFun;
        for (T node : nodes) {
            this.add(node);
        }
    }

    public void add(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.put(this.hashFun.applyAsInt(node.toString() + i), node);
        }
    }

    public void remove(T node) {
        for (int i = 0; i < this.numberOfReplicas; ++i) {
            this.circle.remove(this.hashFun.applyAsInt(node.toString() + i));
        }
    }

    public T get(Object key) {
        if (this.circle.isEmpty()) {
            return null;
        }
        int hash = this.hashFun.applyAsInt(key);
        if (!this.circle.containsKey(hash)) {
            SortedMap<Integer, T> tailMap = this.circle.tailMap(hash);
            hash = tailMap.isEmpty() ? this.circle.firstKey().intValue() : tailMap.firstKey().intValue();
        }
        return (T)this.circle.get(hash);
    }
}

