/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io;

import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import java.nio.ByteBuffer;

public class Buffers {
    private Buffers() {
    }

    public static ByteBuffer copy(ByteBuffer src, int start, int end) {
        return Buffers.copy(src, ByteBuffer.allocate(end - start));
    }

    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest) {
        return Buffers.copy(src, dest, Math.min(src.limit(), dest.remaining()));
    }

    public static ByteBuffer copy(ByteBuffer src, ByteBuffer dest, int length) {
        return Buffers.copy(src, src.position(), dest, dest.position(), length);
    }

    public static ByteBuffer copy(ByteBuffer src, int srcStart, ByteBuffer dest, int destStart, int length) {
        System.arraycopy(src.array(), srcStart, dest.array(), destStart, length);
        return dest;
    }

    public static String readStr(ByteBuffer buffer) {
        return new String(Buffers.readBytes(buffer));
    }

    public static byte[] readBytes(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        byte[] arr = new byte[remaining];
        buffer.get(arr);
        return arr;
    }

    public static byte[] readBytes(ByteBuffer buffer, int maxLength) {
        int remaining = buffer.remaining();
        if (maxLength > remaining) {
            maxLength = remaining;
        }
        byte[] arr = new byte[maxLength];
        buffer.get(arr);
        return arr;
    }

    public static byte[] readBytes(ByteBuffer buffer, int start, int end) {
        byte[] bs = new byte[end - start];
        System.arraycopy(buffer.array(), start, bs, 0, bs.length);
        return bs;
    }

    public static int lineEnd(ByteBuffer buffer) {
        return Buffers.lineEnd(buffer, buffer.remaining());
    }

    public static int lineEnd(ByteBuffer buffer, int maxLength) {
        int primitivePosition = buffer.position();
        boolean canEnd = false;
        int charIndex = primitivePosition;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            ++charIndex;
            if (b == 13) {
                canEnd = true;
            } else {
                if (b == 10) {
                    return canEnd ? charIndex - 2 : charIndex - 1;
                }
                canEnd = false;
            }
            if (charIndex - primitivePosition <= maxLength) continue;
            buffer.position(primitivePosition);
            throw Exceptions.index(Strings.format("position is out of maxLength: {}", maxLength));
        }
        buffer.position(primitivePosition);
        return -1;
    }

    public static String readLine(ByteBuffer buffer) {
        int startPosition = buffer.position();
        int endPosition = Buffers.lineEnd(buffer);
        if (endPosition > startPosition) {
            return new String(Buffers.readBytes(buffer, startPosition, endPosition));
        }
        if (endPosition == startPosition) {
            return "";
        }
        return null;
    }

    public static ByteBuffer create(byte[] data) {
        return ByteBuffer.wrap(data);
    }

    public static ByteBuffer create(String data) {
        return ByteBuffer.wrap(Strings.bytes(data));
    }
}

