/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io;

import cn.orionsec.kit.lang.utils.Arrays1;
import cn.orionsec.kit.lang.utils.Exceptions;
import cn.orionsec.kit.lang.utils.Strings;
import cn.orionsec.kit.lang.utils.io.FileReaders;
import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.StreamWriters;
import cn.orionsec.kit.lang.utils.io.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileWriters {
    private FileWriters() {
    }

    public static void append(File file, byte[] bs) {
        FileWriters.append(file, bs, 0, bs.length);
    }

    public static void append(String file, byte[] bs) {
        FileWriters.append(new File(file), bs, 0, bs.length);
    }

    public static void append(String file, byte[] bs, int off, int len) {
        FileWriters.append(new File(file), bs, off, len);
    }

    public static void append(File file, byte[] bs, int off, int len) {
        try (FileOutputStream out = Files1.openOutputStream(file, true);){
            StreamWriters.write(out, bs, off, len);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void append(File file, String s) {
        FileWriters.append(file, Strings.bytes(s));
    }

    public static void append(String file, String s) {
        FileWriters.append(new File(file), Strings.bytes(s));
    }

    public static void append(File file, String s, String charset) {
        FileWriters.append(file, Strings.bytes(s, charset));
    }

    public static void append(String file, String s, String charset) {
        FileWriters.append(new File(file), Strings.bytes(s, charset));
    }

    public static void append(String file, long offset, byte[] bytes) {
        FileWriters.append(new File(file), offset, bytes, 0, bytes.length);
    }

    public static void append(File file, long offset, byte[] bytes) {
        FileWriters.append(file, offset, bytes, 0, bytes.length);
    }

    public static void append(String file, long offset, byte[] bytes, int off, int len) {
        FileWriters.append(new File(file), offset, bytes, off, len);
    }

    public static void append(File file, long offset, byte[] bytes, int off, int len) {
        RandomAccessFile r;
        FileInputStream in;
        block7: {
            long fileLen = file.length();
            if (offset >= fileLen) {
                FileWriters.append(file, bytes, off, len);
                return;
            }
            in = null;
            r = null;
            try {
                int read;
                if (fileLen - offset <= 8192L) {
                    byte[] bs = new byte[(int)(fileLen - offset + (long)len)];
                    System.arraycopy(bytes, 0, bs, 0, len);
                    r = new RandomAccessFile(file, "rw");
                    r.seek(offset);
                    r.read(bs, len, bs.length - len);
                    r.seek(offset);
                    r.write(bs);
                    break block7;
                }
                r = new RandomAccessFile(file, "rw");
                File endFile = Files1.touchTempFile(true);
                FileWriters.writeToFile(file, offset, endFile);
                r.seek(offset);
                r.write(bytes, off, len);
                in = Files1.openInputStream(endFile);
                byte[] buf = new byte[8192];
                while ((read = in.read(buf)) != -1) {
                    r.write(buf, 0, read);
                }
            }
            catch (Exception e) {
                try {
                    throw Exceptions.ioRuntime(e);
                }
                catch (Throwable throwable) {
                    Streams.close(in);
                    Streams.close(r);
                    throw throwable;
                }
            }
        }
        Streams.close(in);
        Streams.close(r);
    }

    public static void appendLines(File file, long offset, List<String> lines, String charset) {
        long fileLen = file.length();
        boolean append = offset >= fileLen;
        FileInputStream in = null;
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(file, "rw");
            boolean useBuffer = true;
            byte[] bs = null;
            int read = 0;
            File endFile = null;
            if (!append) {
                if (fileLen - offset <= 8192L) {
                    bs = new byte[(int)(fileLen - offset)];
                    r.seek(offset);
                    read = r.read(bs);
                    r.seek(offset);
                } else {
                    endFile = Files1.touchTempFile(true);
                    FileWriters.writeToFile(file, offset, endFile);
                    r.seek(offset);
                    useBuffer = false;
                }
            }
            for (String line : lines) {
                if (charset == null) {
                    r.write(Strings.bytes(line));
                } else {
                    r.write(Strings.bytes(line, charset));
                }
                r.write(10);
            }
            if (!append) {
                if (useBuffer) {
                    r.write(bs, 0, read);
                } else {
                    in = Files1.openInputStream(endFile);
                    bs = new byte[8192];
                    while ((read = in.read(bs)) != -1) {
                        r.write(bs, 0, read);
                    }
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
        finally {
            Streams.close(in);
            Streams.close(r);
        }
    }

    public static void write(File file, byte[] bs) {
        FileWriters.write(file, bs, 0, bs.length);
    }

    public static void write(String file, byte[] bs) {
        FileWriters.write(new File(file), bs, 0, bs.length);
    }

    public static void write(String file, byte[] bs, int off, int len) {
        FileWriters.write(new File(file), bs, off, len);
    }

    public static void write(File file, byte[] bs, int off, int len) {
        try (FileOutputStream out = Files1.openOutputStream(file);){
            StreamWriters.write(out, bs, off, len);
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    public static void write(File file, String s) {
        FileWriters.write(file, Strings.bytes(s));
    }

    public static void write(String file, String s) {
        FileWriters.write(new File(file), Strings.bytes(s));
    }

    public static void write(File file, String s, String charset) {
        FileWriters.write(file, Strings.bytes(s, charset));
    }

    public static void write(String file, String s, String charset) {
        FileWriters.write(new File(file), Strings.bytes(s, charset));
    }

    public static void write(String file, int skipBytes, byte[] bs) {
        FileWriters.write(new File(file), skipBytes, bs, 0, bs.length);
    }

    public static void write(File file, int skipBytes, byte[] bs) {
        FileWriters.write(file, skipBytes, bs, 0, bs.length);
    }

    public static void write(String file, int skipBytes, byte[] bs, int off, int len) {
        FileWriters.write(new File(file), skipBytes, bs, off, len);
    }

    public static void write(File file, int skipBytes, byte[] bs, int off, int len) {
        block43: {
            if (skipBytes > 0) {
                try (FileInputStream in = Files1.openInputStream(file);){
                    byte[] skips = new byte[skipBytes];
                    int read = in.read(skips);
                    try (FileOutputStream out = Files1.openOutputStream(file);){
                        out.write(skips, 0, read);
                        out.write(bs, off, len);
                        break block43;
                    }
                    catch (IOException e) {
                        throw Exceptions.ioRuntime(e);
                    }
                }
                catch (Exception e) {
                    throw Exceptions.ioRuntime(e);
                }
            }
            try (FileOutputStream out = Files1.openOutputStream(file);){
                out.write(bs, off, len);
            }
            catch (IOException e) {
                throw Exceptions.ioRuntime(e);
            }
        }
    }

    public static void replace(String file, int rangeStart, int rangeEnd, byte[] bytes) {
        FileWriters.replace(new File(file), rangeStart, rangeEnd, bytes, 0, bytes.length);
    }

    public static void replace(File file, int rangeStart, int rangeEnd, byte[] bytes) {
        FileWriters.replace(file, rangeStart, rangeEnd, bytes, 0, bytes.length);
    }

    public static void replace(String file, int rangeStart, int rangeEnd, byte[] bytes, int off, int len) {
        FileWriters.replace(new File(file), rangeStart, rangeEnd, bytes, off, len);
    }

    public static void replace(File file, int rangeStart, int rangeEnd, byte[] bytes, int off, int len) {
        long fileLen = file.length();
        boolean append = false;
        if (rangeStart < 0 || rangeEnd < 0) {
            throw Exceptions.argument("range start and range end not less than 0");
        }
        if (rangeStart > rangeEnd) {
            int tmpStart = rangeStart;
            rangeStart = rangeEnd;
            rangeEnd = tmpStart;
        }
        if ((long)rangeStart >= fileLen) {
            append = true;
        } else if ((long)rangeEnd > fileLen) {
            rangeEnd = (int)fileLen;
        }
        if (append) {
            FileWriters.append(file, bytes, off, len);
            return;
        }
        boolean startBuffer = false;
        boolean endBuffer = false;
        if (rangeStart <= 8192) {
            startBuffer = true;
        }
        if (fileLen - (long)rangeEnd <= 8192L) {
            endBuffer = true;
        }
        ArrayList<Closeable> close = new ArrayList<Closeable>();
        try {
            if (startBuffer && endBuffer) {
                RandomAccessFile r = new RandomAccessFile(file, "r");
                close.add(r);
                byte[] s = FileReaders.read(r, 0L, (long)rangeStart);
                byte[] e = FileReaders.read(r, rangeEnd, fileLen);
                byte[] re = Arrays1.newBytes(s.length + e.length + len);
                int i = 0;
                System.arraycopy(s, 0, re, 0, s.length);
                System.arraycopy(bytes, off, re, i += s.length, len);
                System.arraycopy(e, 0, re, i += len, e.length);
                FileWriters.write(file, re);
            } else if (startBuffer) {
                RandomAccessFile r = new RandomAccessFile(file, "r");
                close.add(r);
                byte[] s = FileReaders.read(r, 0L, (long)rangeStart);
                byte[] n = new byte[s.length + len];
                int i = 0;
                File endFile = Files1.touchTempFile(true);
                FileWriters.writeToFile(file, (long)rangeEnd, endFile);
                System.arraycopy(s, 0, n, 0, i += s.length);
                System.arraycopy(bytes, off, n, i, len);
                FileWriters.write(file, n);
                Files1.mergeFile(endFile, file);
            } else if (endBuffer) {
                RandomAccessFile r = new RandomAccessFile(file, "r");
                close.add(r);
                byte[] e = FileReaders.read(r, rangeEnd, fileLen);
                byte[] n = new byte[e.length + len];
                System.arraycopy(bytes, off, n, 0, len);
                System.arraycopy(e, 0, n, len, e.length);
                RandomAccessFile rw = new RandomAccessFile(file, "rw");
                close.add(rw);
                rw.seek(rangeStart);
                rw.write(n);
            } else {
                int read;
                File endFile = Files1.touchTempFile(true);
                FileWriters.writeToFile(file, (long)rangeEnd, endFile);
                RandomAccessFile rw = new RandomAccessFile(file, "rw");
                close.add(rw);
                rw.seek(rangeStart);
                rw.write(bytes, off, len);
                byte[] bs = new byte[8192];
                FileInputStream in = Files1.openInputStream(endFile);
                close.add(in);
                while ((read = in.read(bs)) != -1) {
                    rw.write(bs, 0, read);
                }
            }
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
        finally {
            close.forEach(Streams::close);
        }
    }

    public static void writeToFile(File file, long off, File targetFile) {
        FileWriters.writeToFile(file, off, (int)(file.length() - off), targetFile);
    }

    public static void writeToFile(File file, int len, File targetFile) {
        FileWriters.writeToFile(file, 0L, len, targetFile);
    }

    public static void writeToFile(File file, long off, int len, File targetFile) {
        FileOutputStream out;
        FileInputStream in;
        block8: {
            block7: {
                in = null;
                out = null;
                if (off > 0L || (long)len < file.length()) break block7;
                Files1.copy(file, targetFile);
                Streams.close(in);
                Streams.close(out);
                return;
            }
            in = Files1.openInputStream(file);
            if (in.skip(off) >= off) break block8;
            Streams.close(in);
            Streams.close(out);
            return;
        }
        try {
            int read;
            out = Files1.openOutputStream(targetFile);
            byte[] buf = new byte[8192];
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (Exception e) {
            try {
                throw Exceptions.ioRuntime(e);
            }
            catch (Throwable throwable) {
                Streams.close(in);
                Streams.close(out);
                throw throwable;
            }
        }
        Streams.close(in);
        Streams.close(out);
    }

    public static void writeFast(String file, byte[] bs) {
        FileWriters.writeFast(Paths.get(file, new String[0]), bs, 0, bs.length, false);
    }

    public static void writeFast(File file, byte[] bs) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), bs, 0, bs.length, false);
    }

    public static void writeFast(Path file, byte[] bs) {
        FileWriters.writeFast(file, bs, 0, bs.length, false);
    }

    public static void writeFast(String file, byte[] bs, int off, int len) {
        FileWriters.writeFast(Paths.get(file, new String[0]), bs, off, len, false);
    }

    public static void writeFast(File file, byte[] bs, int off, int len) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), bs, off, len, false);
    }

    public static void writeFast(Path file, byte[] bs, int off, int len) {
        FileWriters.writeFast(file, bs, off, len, false);
    }

    public static void writeFast(String file, InputStream in) {
        FileWriters.writeFast(Paths.get(file, new String[0]), in, false, false);
    }

    public static void writeFast(File file, InputStream in) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), in, false, false);
    }

    public static void writeFast(Path file, InputStream in) {
        FileWriters.writeFast(file, in, false, false);
    }

    public static void writeFast(String file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(Paths.get(file, new String[0]), in, autoClose, false);
    }

    public static void writeFast(File file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), in, autoClose, false);
    }

    public static void writeFast(Path file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(file, in, autoClose, false);
    }

    public static void appendFast(String file, byte[] bs) {
        FileWriters.writeFast(Paths.get(file, new String[0]), bs, 0, bs.length, true);
    }

    public static void appendFast(File file, byte[] bs) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), bs, 0, bs.length, true);
    }

    public static void appendFast(Path file, byte[] bs) {
        FileWriters.writeFast(file, bs, 0, bs.length, true);
    }

    public static void appendFast(String file, byte[] bs, int off, int len) {
        FileWriters.writeFast(Paths.get(file, new String[0]), bs, off, len, true);
    }

    public static void appendFast(File file, byte[] bs, int off, int len) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), bs, off, len, true);
    }

    public static void appendFast(Path file, byte[] bs, int off, int len) {
        FileWriters.writeFast(file, bs, off, len, true);
    }

    public static void appendFast(String file, InputStream in) {
        FileWriters.writeFast(Paths.get(file, new String[0]), in, false, true);
    }

    public static void appendFast(File file, InputStream in) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), in, false, true);
    }

    public static void appendFast(Path file, InputStream in) {
        FileWriters.writeFast(file, in, false, true);
    }

    public static void appendFast(String file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(Paths.get(file, new String[0]), in, autoClose, true);
    }

    public static void appendFast(File file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(Paths.get(file.getAbsolutePath(), new String[0]), in, autoClose, true);
    }

    public static void appendFast(Path file, InputStream in, boolean autoClose) {
        FileWriters.writeFast(file, in, autoClose, true);
    }

    private static void writeFast(Path file, byte[] bs, int off, int len, boolean append) {
        try (OutputStream out = Files1.openOutputStreamFast(file, append);){
            StreamWriters.write(out, bs, off, len);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
    }

    private static void writeFast(Path file, InputStream in, boolean autoClose, boolean append) {
        try (OutputStream out = Files1.openOutputStreamFast(file, append);){
            Streams.transfer(in, out);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime(e);
        }
        finally {
            Streams.close(in, autoClose);
        }
    }
}

