/*
 * Decompiled with CFR 0.152.
 */
package cn.orionsec.kit.lang.utils.io.compress.mix;

import cn.orionsec.kit.lang.utils.io.Files1;
import cn.orionsec.kit.lang.utils.io.Streams;
import cn.orionsec.kit.lang.utils.io.compress.BaseFileDecompressor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TarGzDecompressor
extends BaseFileDecompressor {
    private TarArchiveInputStream inputStream;

    public TarGzDecompressor() {
        this("tar.gz");
    }

    public TarGzDecompressor(String suffix) {
        super(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDecompress() throws Exception {
        try (BufferedInputStream bi = new BufferedInputStream(Files1.openInputStreamFast(this.decompressFile));
             GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)bi);){
            ArchiveEntry entry;
            this.inputStream = new TarArchiveInputStream((InputStream)gzIn);
            while ((entry = this.inputStream.getNextEntry()) != null) {
                File file = new File(this.decompressTargetPath, entry.getName());
                if (entry.isDirectory()) {
                    Files1.mkdirs(file);
                    continue;
                }
                OutputStream out = Files1.openOutputStreamFast(file);
                Throwable throwable = null;
                try {
                    Streams.transfer((InputStream)this.inputStream, out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
        }
        finally {
            Streams.close((AutoCloseable)this.inputStream);
        }
    }

    public TarArchiveInputStream getCloseable() {
        return this.inputStream;
    }
}

